package com.rocoinfo.rocomall.service.product;

import java.util.List;

import com.rocoinfo.rocomall.common.service.IBaseService;
import com.rocoinfo.rocomall.entity.Catalog;

public interface ICatalogService extends IBaseService<Catalog> {

	/**
	 * 构建分类树
	 */
	public List<Catalog> buildCatalogTree(boolean isRequireTreeLine);

	/**
	 * 查询子分类列表
	 * 
	 * @param parentId 父分类Id, 0表示查询顶级分类
	 * @param states 分类显示状态，如果是多个状态，则返回多个状态值分类的并集, states是null或空数组,则返回所有状态的分类
	 */
	public List<Catalog> findSubCatalogs(final long parentId, Catalog.Status... states);

	public List<Catalog> findByCatalogIds(List<Long> catalogIds);

	/**
	 * @param id Catalog ID
	 * @return 返回包含指定节点ID和所有后代节点ID的List
	 */
	public List<Long> findSubTreeIds(Long id);

	/**
	 * 返回所有Catalog的树形结构.
	 * 
	 * @param isAll 是否显示全部，如果为false 则屏蔽掉都不可见的分类
	 */
	public List<Catalog> tree(boolean isAll);

	/**
	 * 根据name条件查询分类
	 * 
	 * @param parame
	 * @return
	 */
	public List<Long> findCatalogIdsbyName(String name);

}
