package com.rocoinfo.rocomall.service.wx;

import com.rocoinfo.rocomall.dto.StatusDto;
import com.rocoinfo.rocomall.entity.wx.WXUser;

/**
 * <dl>
 * <dd>描述: 访问微信公共平台 接口api Service</dd>
 * <dd>公司: 大城若谷信息技术有限公司</dd>
 * <dd>创建时间：2016年3月1日 上午11:10:50</dd>
 * <dd>创建人： 张敏</dd>
 * </dl>
 */
public interface IWxApiService {
	/**
	 * 获取访问token http GET请求方式: 获取access_token 请求地址 access_token有效期为7200秒，重复获取将导致上次获取的access_token失效
	 * 公众号可以使用AppID和AppSecret调用本接口来获取access_token
	 * 
	 * 正常情况下，微信会返回下述JSON数据包给公众号： {"access_token":
	 * "WDk2fDLcMe_hz63v5iCwM0dDJvDK9h7A1QtBCggCm0A_swd_BD3Ps4Tl-XqiXQ92dYS8wEx_qeoc5aPTuoZ_eQk5BrbOuA34mlUHZNRkcDUzQZHpLBr2KgJZCtEDLn0GDSo0eKkofhmJbXavbdyYeg"
	 * ,"expires_in":7200}
	 */
	public String getAccessToken(String appId, String appSecret);

	/***
	 * 创建微信自定义菜单，返回创建结果消息 正确时的返回JSON数据包如下： {"errcode":0,"errmsg":"ok"} 错误时的返回JSON数据包如下（示例为无效菜单名长度）：
	 * {"errcode":40018,"errmsg":"invalid button name size"}
	 */
	public StatusDto<String> createWeixinMenu(String appId, String appSecret);

	/**
	 * 到微信公共平台，拉取微信用户更多的基本信息,没有拉取到则返回null对象
	 * 
	 * @param openId
	 */
	public WXUser getWxUserInfo(String appId, String appSecret, final String openId);

	/***
	 * 人工主动发送客服消息【下发回复/群发push】 http请求方式: POST
	 */
	//public <T extends SendMsg> void sendMessage(T sendMsg);

	/**
	 * 微信下载多媒体文件
	 * 
	 * @param mediaId 要下载的文件 mediaId号
	 * @param saveRealDir 下载下来的多媒体文件 保存的目录
	 */
	public void downloadMediaFile(final String mediaId, final String saveRealDir);

	// =============  微信公共平台jsSdk接口  ==============

	/**
	 * 生成签名之前必须先了解一下jsapi_ticket，jsapi_ticket是公众号用于调用微信JS接口的临时票据。
	 * 正常情况下，jsapi_ticket的有效期为7200秒，通过access_token来获取。由于获取jsapi_ticket的api调用次数非常有限
	 * ，频繁刷新jsapi_ticket会导致api调用受限，影响自身业务，开发者必须在自己的服务全局缓存jsapi_ticket <br/>
	 * 成功返回如下JSON：<br/>
	 * { "errcode":0, "errmsg":"ok",
	 * "ticket":"bxLdikRXVbTPdHSM05e5u5sUoXNKd8-41ZO3MhKoyN5OfkWITDGgnr2fwJ0m9E8NYzWKVZvdVtaUgWvsdshFKA",
	 * "expires_in":7200 } <br/>
	 * 获得jsapi_ticket之后，就可以生成JS-SDK权限验证的签名了
	 */
	public String getJsApiTicket(String appId, String appSecret);
}
