package com.rocoinfo.rocomall.utils;

import org.springside.modules.security.utils.Digests;
import org.springside.modules.utils.Encodes;

import com.rocoinfo.rocomall.entity.account.Account;

/**
 * @author zhangmin
 */
public final class PasswordUtil {
	private static final int SALT_SIZE = 8;
	public static final String HASH_ALGORITHM = "SHA-1";
	public static final int HASH_ITERATIONS = 1024;

	/**
	 * 设定安全的密码，生成随机的salt并经过1024次 sha-1 hash
	 */
	public static void entryptPassword(Account account) {
		account.setSalt(generateSalt());
		account.setPassword(hashPassword(account.getPlainPassword(), account.getSalt()));
	}

	public static String generateSalt() {
		byte[] salt = Digests.generateSalt(SALT_SIZE);
		return Encodes.encodeHex(salt);
	}

	public static String hashPassword(String plainPassword, String salt) {
		byte[] hashPassword = Digests.sha1(plainPassword.getBytes(), Encodes.decodeHex(salt), HASH_ITERATIONS);
		return Encodes.encodeHex(hashPassword);
	}

	public static void main(String[] args) {
		Account account = new Account();
		account.setPlainPassword("123456");
		entryptPassword(account);
		System.out.println("salt=" + account.getSalt());
		System.out.println("hasPsw=" + account.getPassword());
	}
}
