/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.entity.activity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.google.common.collect.Sets;
import com.rocoinfo.rocomall.entity.IdEntity;
import com.rocoinfo.rocomall.entity.Supplier;
import com.rocoinfo.rocomall.entity.activity.ActivitySku;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import org.springframework.data.annotation.Transient;
import org.springframework.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JsonIgnoreProperties(ignoreUnknown=true)
public class Activity
extends IdEntity {
    private static final long serialVersionUID = 1177054672620656211L;
    private String name;
    private String promotionWord;
    private Type type;
    private Date startTime;
    private Date endTime;
    private Status status;
    private Supplier supplier;
    private Boolean onlyActSale;
    private Integer joinCent;
    private Integer auctIncrMin;
    private Integer auctIncrMax;
    private Integer auctInitCent;
    private Integer auctTopN;
    private Integer seq;
    private Integer auctionMaxCent;
    @Transient
    private List<ActivitySku> activitySkus;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPromotionWord() {
        return this.promotionWord;
    }

    public void setPromotionWord(String promotionWord) {
        this.promotionWord = promotionWord;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public int getAvailableStockQuantity() {
        int availableStock = 0;
        if (!CollectionUtils.isEmpty(this.activitySkus)) {
            HashSet stockSet = Sets.newHashSet();
            for (ActivitySku actSku : this.activitySkus) {
                if (actSku == null || actSku.getSku() == null) continue;
                stockSet.add(actSku.getSku().getAvailableStockQuantity() / actSku.getCount());
            }
            if (!stockSet.isEmpty()) {
                availableStock = (Integer)Collections.min(stockSet);
            }
        }
        return availableStock;
    }

    public int getActivitySaleCent() {
        int actCent = 0;
        if (!CollectionUtils.isEmpty(this.activitySkus)) {
            for (ActivitySku actSku : this.activitySkus) {
                if (actSku == null || actSku.getSku() == null) continue;
                actCent += actSku.getCent().intValue();
            }
        }
        return actCent;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Supplier getSupplier() {
        return this.supplier;
    }

    public void setSupplier(Supplier supplier) {
        this.supplier = supplier;
    }

    public Integer getJoinCent() {
        return this.joinCent;
    }

    public void setJoinCent(Integer joinCent) {
        this.joinCent = joinCent;
    }

    public Integer getAuctIncrMin() {
        return this.auctIncrMin;
    }

    public void setAuctIncrMin(Integer auctIncrMin) {
        this.auctIncrMin = auctIncrMin;
    }

    public Integer getAuctIncrMax() {
        return this.auctIncrMax;
    }

    public void setAuctIncrMax(Integer auctIncrMax) {
        this.auctIncrMax = auctIncrMax;
    }

    public Integer getAuctInitCent() {
        return this.auctInitCent;
    }

    public void setAuctInitCent(Integer auctInitCent) {
        this.auctInitCent = auctInitCent;
    }

    public Integer getAuctTopN() {
        return this.auctTopN;
    }

    public void setAuctTopN(Integer auctTopN) {
        this.auctTopN = auctTopN;
    }

    public boolean isStart() {
        return this.startTime != null && this.startTime.getTime() < System.currentTimeMillis();
    }

    public boolean isStop() {
        return this.endTime != null && this.endTime.getTime() < System.currentTimeMillis();
    }

    public Integer getSeq() {
        return this.seq;
    }

    public void setSeq(Integer seq) {
        this.seq = seq;
    }

    public List<ActivitySku> getActivitySkus() {
        return this.activitySkus;
    }

    public void setActivitySkus(List<ActivitySku> activitySkus) {
        this.activitySkus = activitySkus;
    }

    public Boolean getOnlyActSale() {
        return this.onlyActSale;
    }

    public void setOnlyActSale(Boolean onlyActSale) {
        this.onlyActSale = onlyActSale;
    }

    public boolean isCanJoin() {
        return this.status == Status.LIST && this.isStart() && !this.isStop() && this.startTime.before(this.endTime);
    }

    public boolean isCanJoinAfterAddcompensation() {
        if (this.isCanJoin()) {
            return true;
        }
        int compensation = 3000;
        if (this.status == Status.LIST && this.isStart()) {
            return this.getEndTime().getTime() + (long)compensation >= System.currentTimeMillis();
        }
        return false;
    }

    public Integer getAuctionMaxCent() {
        return this.auctionMaxCent;
    }

    public void setAuctionMaxCent(Integer auctionMaxCent) {
        this.auctionMaxCent = auctionMaxCent;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        AUCTION("\u62cd\u5356"),
        PRESALE("\u9884\u552e"),
        LIMITED_TIME_OFFER("\u9650\u65f6\u62a2\u8d2d"),
        SCRAPE_CARD("\u522e\u522e\u5361"),
        TURN_TABLE("\u8f6c\u76d8\u62bd\u5956"),
        SECKILL("\u79d2\u6740");

        private String label;

        private Type(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        DRAFT("\u8349\u7a3f"),
        AUDIT("\u5ba1\u6279\u4e2d"),
        READY_LIST("\u5f85\u4e0a\u67b6"),
        REFUSE("\u5df2\u62d2\u7edd"),
        LIST("\u5df2\u4e0a\u67b6"),
        DELIST("\u5df2\u4e0b\u67b6"),
        DISCARD("\u5df2\u4f5c\u5e9f");

        private String label;

        private Status(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }

        public static boolean isAllowChangeStatus(Status from, Status to) {
            EnumSet<Status> statusSets = Status.getAllowChangeStatus(from);
            if (!CollectionUtils.isEmpty(statusSets)) {
                for (Status status : statusSets) {
                    if (to != status) continue;
                    return true;
                }
            }
            return false;
        }

        public static EnumSet<Status> getAllowChangeStatus(Status from) {
            EnumSet<Status> statusSets = EnumSet.noneOf(Status.class);
            if (from == DRAFT) {
                statusSets.add(DISCARD);
                statusSets.add(AUDIT);
            }
            if (from == DISCARD) {
                // empty if block
            }
            if (from == AUDIT) {
                statusSets.add(REFUSE);
                statusSets.add(READY_LIST);
            }
            if (from == REFUSE) {
                statusSets.add(DISCARD);
                statusSets.add(DRAFT);
            }
            if (from == LIST) {
                statusSets.add(DELIST);
            }
            if (from == READY_LIST) {
                statusSets.add(LIST);
                statusSets.add(DISCARD);
            }
            if (from == DELIST) {
                statusSets.add(LIST);
                statusSets.add(DISCARD);
            }
            return statusSets;
        }
    }
}

