/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.entity.wx;

import com.rocoinfo.rocomall.entity.wx.AbstractWX;
import com.rocoinfo.rocomall.entity.wx.MsgEntity;
import com.rocoinfo.rocomall.entity.wx.MsgReceiverEntity;
import com.rocoinfo.rocomall.entity.wx.SingleMsgSingleReceiver;
import com.rocoinfo.rocomall.entity.wx.WXItem;
import com.rocoinfo.rocomall.entity.wx.WXMusic;
import com.rocoinfo.rocomall.enumconst.WXMsgType;
import com.rocoinfo.rocomall.utils.CDATAConverter;
import com.rocoinfo.rocomall.utils.CodeGenerator;
import com.rocoinfo.rocomall.utils.XStreamUtils;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XStreamAlias(value="xml")
@XStreamConverter(value=CDATAConverter.class)
public class WXMsg
extends AbstractWX
implements Serializable {
    private static final long serialVersionUID = -7110176973111728271L;
    @XStreamAlias(value="MsgId")
    private Long msgId;
    @XStreamAlias(value="ToUserName")
    private String toUserName;
    @XStreamAlias(value="FromUserName")
    private String fromUserName;
    @XStreamAlias(value="CreateTime")
    private Integer createTime;
    @XStreamAlias(value="MsgType")
    private String msgType;
    @XStreamAlias(value="Recognition")
    private String recognition;
    @XStreamAlias(value="Event")
    private String event;
    @XStreamAlias(value="EventKey")
    private String eventKey;
    @XStreamAlias(value="Content")
    private String content;
    @XStreamAlias(value="PicUrl")
    private String picUrl;
    @XStreamAlias(value="MediaId")
    private String mediaId;
    @XStreamAlias(value="Format")
    private String format;
    @XStreamAlias(value="ThumbMediaId")
    private String humbMediaId;
    @XStreamAlias(value="Location_X")
    private BigDecimal locationX;
    @XStreamAlias(value="Location_Y")
    private BigDecimal locationY;
    @XStreamAlias(value="Scale")
    private BigDecimal scale;
    @XStreamAlias(value="Label")
    private String label;
    @XStreamAlias(value="Title")
    private String title;
    @XStreamAlias(value="Description")
    private String description;
    @XStreamAlias(value="Url")
    private String url;
    @XStreamAlias(value="ArticleCount")
    private Integer articleCount;
    @XStreamAlias(value="Articles")
    private List<WXItem> articles;
    @XStreamAlias(value="Music")
    private WXMusic music;

    private void populateTxtMsgContent(MsgEntity entity) {
        entity.setContent(this.getContent());
    }

    private void populateImageMsgContent(MsgEntity entity) {
        entity.setPicUrl(this.getPicUrl());
        entity.setMediaId(this.getMediaId());
    }

    private void populateVoiceMsgContent(MsgEntity entity) {
        entity.setMediaId(this.getMediaId());
        entity.setFormat(this.getFormat());
    }

    private void populateVideoMsgContent(MsgEntity entity) {
        entity.setMediaId(this.getMediaId());
        entity.setThumbMediaId(this.getHumbMediaId());
    }

    private void populateLinkMsgContent(MsgEntity entity) {
        entity.setUrl(this.getUrl());
        entity.setTitle(this.getTitle());
        entity.setDescription(this.getDescription());
    }

    private void populateLocationMsgContent(MsgEntity entity) {
        entity.setLocationX(this.getLocationX());
        entity.setLocationY(this.getLocationY());
        entity.setScale(this.getScale());
        entity.setLabel(this.getLabel());
    }

    public SingleMsgSingleReceiver valueOfWxMessage() {
        SingleMsgSingleReceiver txtMessage = new SingleMsgSingleReceiver(CodeGenerator.generateWxMessageId()){

            public MsgEntity getMsgEntity() {
                MsgEntity entity = new MsgEntity();
                entity.setMsgType(WXMsgType.valueOf(WXMsg.this.getMsgType()));
                entity.setMessageId(this.getMessageId());
                entity.setCreateTime((int)((long)WXMsg.this.getCreateTime().intValue()));
                entity.setMsgId(WXMsg.this.getMsgId());
                switch (entity.getMsgType()) {
                    case text: {
                        WXMsg.this.populateTxtMsgContent(entity);
                        break;
                    }
                    case image: {
                        WXMsg.this.populateImageMsgContent(entity);
                        break;
                    }
                    case voice: {
                        WXMsg.this.populateVoiceMsgContent(entity);
                        break;
                    }
                    case video: {
                        WXMsg.this.populateVideoMsgContent(entity);
                        break;
                    }
                    case link: {
                        WXMsg.this.populateLinkMsgContent(entity);
                        break;
                    }
                    case location: {
                        WXMsg.this.populateLocationMsgContent(entity);
                    }
                }
                return entity;
            }

            public MsgReceiverEntity getMsgReceiver() {
                MsgReceiverEntity receiver = new MsgReceiverEntity();
                receiver.setDateline((int)((long)WXMsg.this.getCreateTime().intValue()));
                receiver.setMessageId(this.getMessageId());
                receiver.setReceiver(WXMsg.this.getToUserName());
                receiver.setSender(WXMsg.this.getFromUserName());
                return receiver;
            }
        };
        return txtMessage;
    }

    public String getToUserName() {
        return this.toUserName;
    }

    public void setToUserName(String toUserName) {
        this.toUserName = toUserName;
    }

    public String getFromUserName() {
        return this.fromUserName;
    }

    public void setFromUserName(String fromUserName) {
        this.fromUserName = fromUserName;
    }

    public Integer getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Integer createTime) {
        this.createTime = createTime;
    }

    public String getMsgType() {
        return this.msgType;
    }

    public void setMsgType(String msgType) {
        this.msgType = msgType;
    }

    public String getEvent() {
        return this.event;
    }

    public void setEvent(String event) {
        this.event = event;
    }

    public String getEventKey() {
        return this.eventKey;
    }

    public void setEventKey(String eventKey) {
        this.eventKey = eventKey;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getPicUrl() {
        return this.picUrl;
    }

    public void setPicUrl(String picUrl) {
        this.picUrl = picUrl;
    }

    public String getMediaId() {
        return this.mediaId;
    }

    public void setMediaId(String mediaId) {
        this.mediaId = mediaId;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getHumbMediaId() {
        return this.humbMediaId;
    }

    public void setHumbMediaId(String humbMediaId) {
        this.humbMediaId = humbMediaId;
    }

    public BigDecimal getLocationX() {
        return this.locationX;
    }

    public void setLocationX(BigDecimal locationX) {
        this.locationX = locationX;
    }

    public BigDecimal getLocationY() {
        return this.locationY;
    }

    public void setLocationY(BigDecimal locationY) {
        this.locationY = locationY;
    }

    public String getLabel() {
        return this.label;
    }

    public BigDecimal getScale() {
        return this.scale;
    }

    public void setScale(BigDecimal scale) {
        this.scale = scale;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Integer getArticleCount() {
        return this.articleCount;
    }

    public void setArticleCount(Integer articleCount) {
        this.articleCount = articleCount;
    }

    public List<WXItem> getArticles() {
        return this.articles;
    }

    public void setArticles(List<WXItem> articles) {
        this.articles = articles;
    }

    public Long getMsgId() {
        return this.msgId;
    }

    public void setMsgId(Long msgId) {
        this.msgId = msgId;
    }

    public WXMusic getMusic() {
        return this.music;
    }

    public void setMusic(WXMusic music) {
        this.music = music;
    }

    public static void main(String[] args) {
        WXMsg wxMsg = new WXMsg();
        wxMsg.setToUserName("\u5176\u5b9e\u5c0f\u5c0f\u9c7c");
        wxMsg.setCreateTime((int)(System.currentTimeMillis() / 1000L));
        wxMsg.setMsgType("news");
        wxMsg.setContent("\u4eca\u5929\u7684\u5929\u6c14\u60c5\u51b5");
        wxMsg.setArticleCount(2);
        WXItem item1 = new WXItem();
        item1.setTitle("\u5317\u4eac\u5929\u6c14");
        item1.setDescription("\u5317\u4eac\u5929\u6c14\u60c5\u51b5");
        item1.setPicurl("http://localhost:8080/pic/beijing_raining.jpg");
        item1.setUrl("http://localhost:8080/link/beijing.htm");
        WXItem item2 = new WXItem();
        item2.setTitle("\u4e0a\u6d77\u5929\u6c14");
        item2.setDescription("\u4e0a\u6d77\u5929\u6c14\u60c5\u51b5");
        item2.setPicurl("http://localhost:8080/pic/shanghai_raining.jpg");
        item2.setUrl("http://localhost:8080/link/shanghai.htm");
        ArrayList<WXItem> itemList = new ArrayList<WXItem>();
        itemList.add(item1);
        itemList.add(item2);
        wxMsg.setArticles(itemList);
        XStream xStream = XStreamUtils.getDefaultXStream();
        System.out.println(xStream.toXML((Object)wxMsg));
        wxMsg = (WXMsg)xStream.fromXML(xStream.toXML((Object)wxMsg));
        System.out.println(wxMsg.getMsgType());
        System.out.println(wxMsg.getLocationX());
    }

    public String getRecognition() {
        return this.recognition;
    }

    public void setRecognition(String recognition) {
        this.recognition = recognition;
    }
}

