/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.jms;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessageCreator;

public class StockMessageProducer {
    private Logger logger = LoggerFactory.getLogger(StockMessageProducer.class);
    private JmsTemplate jmsTemplate;
    private Destination notifyQueue;

    public void sendQueue(final String proId, final int stock) {
        this.logger.debug("\u6b63\u5728JMS\u6d88\u606f\u3002proId: {}, stock: {}", (Object)proId, (Object)stock);
        this.jmsTemplate.send(this.notifyQueue, new MessageCreator(){

            public Message createMessage(Session session) throws JMSException {
                MapMessage mapMessage = session.createMapMessage();
                mapMessage.setString("proId", proId);
                mapMessage.setInt("stock", stock);
                return mapMessage;
            }
        });
    }

    public void setJmsTemplate(JmsTemplate jmsTemplate) {
        this.jmsTemplate = jmsTemplate;
    }

    public void setNotifyQueue(Destination notifyQueue) {
        this.notifyQueue = notifyQueue;
    }
}

