/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.pay;

import com.rocoinfo.rocomall.common.service.CrudService;
import com.rocoinfo.rocomall.common.service.ServiceException;
import com.rocoinfo.rocomall.entity.BankPaylog;
import com.rocoinfo.rocomall.entity.order.Order;
import com.rocoinfo.rocomall.entity.order.OrderItem;
import com.rocoinfo.rocomall.enumconst.BankType;
import com.rocoinfo.rocomall.enumconst.PayStatus;
import com.rocoinfo.rocomall.pay.CommonPayDto;
import com.rocoinfo.rocomall.pay.IBankPayLogService;
import com.rocoinfo.rocomall.pay.alipay.AlipayInterfaceHelper;
import com.rocoinfo.rocomall.pay.chinabank.ChinaBankPayHelper;
import com.rocoinfo.rocomall.pay.chinapay.ChinaPayInterfaceHelper;
import com.rocoinfo.rocomall.pay.kuaiqian.KuaiQianParm;
import com.rocoinfo.rocomall.pay.kuaiqian.KuaiQianPayHelper;
import com.rocoinfo.rocomall.pay.wechat.NotifyResultParm;
import com.rocoinfo.rocomall.pay.wechat.UnifiedOrderParm;
import com.rocoinfo.rocomall.pay.wechat.WxpayHelper;
import com.rocoinfo.rocomall.repository.BankPayLogDao;
import com.rocoinfo.rocomall.service.order.IOrderItemService;
import com.rocoinfo.rocomall.service.order.IOrderService;
import com.rocoinfo.rocomall.utils.XmlUtil;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.aop.framework.AopContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class BankPayLogService
extends CrudService<BankPayLogDao, BankPaylog>
implements IBankPayLogService {
    @Autowired
    private IOrderService orderService;
    @Autowired
    private IOrderItemService orderItemService;

    @Override
    public CommonPayDto buildPayInfo(Long orderId, String returnUrl, String notifyUrl, BankType bankType) {
        Order order = (Order)this.orderService.getById(orderId);
        if (order == null) {
            throw new ServiceException("\u4e0d\u5b58\u5728\u8ba2\u5355");
        }
        double amount = order.getCashAmt() + order.getDeliverFee();
        String productName = "\u7535\u8111";
        Date orderCreateTm = new Date();
        if (this.isPaySuccess(orderId)) {
            throw new ServiceException("\u8be5\u8ba2\u5355\u5df2\u7ecf\u652f\u4ed8\u6210\u529f");
        }
        BankPaylog log = this.createOrFindBankPayLogByOrderId(orderId, bankType, amount, orderCreateTm);
        Map<String, String> payParm = null;
        String url = null;
        String methodType = "post";
        switch (bankType) {
            case ALIPAY: {
                payParm = AlipayInterfaceHelper.buildQueryParam(new AlipayInterfaceHelper.AlipayQueryBaseMeta(log.getBankOrderId(), productName, amount, returnUrl, notifyUrl));
                url = "https://mapi.alipay.com/gateway.do";
                methodType = "get";
                break;
            }
            case CHINAPAY: {
                payParm = ChinaPayInterfaceHelper.buildQueryParam(log.getBankOrderId(), amount, notifyUrl, returnUrl);
                url = "https://payment.chinapay.com/pay/TransGet";
                break;
            }
            case CHINABANK: {
                ChinaBankPayHelper.ChBankQueryBaseMeta chbank = new ChinaBankPayHelper.ChBankQueryBaseMeta(log.getBankOrderId(), amount, returnUrl, notifyUrl);
                payParm = ChinaBankPayHelper.buildQueryParam(chbank);
                url = "https://pay3.chinabank.com.cn/PayGate";
                break;
            }
            case WECHAT: {
                int am = (int)(amount * 100.0);
                payParm = WxpayHelper.wxUnifiedorder(new UnifiedOrderParm(productName, log.getBankOrderId(), am, notifyUrl));
                break;
            }
            case KUAIQIAN: {
                int amk = (int)(amount * 100.0);
                payParm = KuaiQianPayHelper.buildQueryParam(new KuaiQianParm(log.getBankOrderId(), String.valueOf(amk), notifyUrl));
                url = "https://sandbox.99bill.com/gateway/recvMerchantInfoAction.htm";
            }
        }
        return new CommonPayDto(bankType, url, payParm, methodType);
    }

    private BankPaylog createOrFindBankPayLogByOrderId(Long orderId, BankType bankType, double amount, Date orderCreateTm) {
        String orderidStr = String.valueOf(orderId);
        BankPaylog log = this.findByOrderidAndType(orderidStr, bankType);
        if (log != null) {
            return log;
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmssS");
        String timStr = formatter.format(orderCreateTm);
        String tempOrderId = timStr + orderidStr;
        switch (bankType) {
            case ALIPAY: {
                tempOrderId = StringUtils.substring((String)tempOrderId, (int)(tempOrderId.length() - 12));
                break;
            }
            case CHINAPAY: {
                tempOrderId = StringUtils.substring((String)tempOrderId, (int)(tempOrderId.length() - 16));
                break;
            }
            case CHINABANK: {
                SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
                tempOrderId = format.format(orderCreateTm) + "-" + ChinaBankPayHelper.v_mid + "-" + orderidStr;
                break;
            }
            case WECHAT: {
                tempOrderId = StringUtils.substring((String)tempOrderId, (int)(tempOrderId.length() - 13));
                break;
            }
            case KUAIQIAN: {
                tempOrderId = StringUtils.substring((String)tempOrderId, (int)(tempOrderId.length() - 13));
            }
        }
        BankPaylog payLog = new BankPaylog();
        payLog.setBankType(bankType);
        payLog.setSelfOrderId(orderidStr);
        payLog.setBankOrderId(tempOrderId);
        payLog.setAmount(amount);
        payLog.setCreateTm(new Date());
        payLog.setPayStatus(PayStatus.INIT);
        this.insert(payLog);
        return payLog;
    }

    private BankPaylog findByOrderidAndType(String id, BankType bankType) {
        return ((BankPayLogDao)this.entityDao).findBySelfOrderIdAndBankType(id, bankType);
    }

    @Override
    public boolean isPaySuccess(Long id) {
        return ((BankPayLogDao)this.entityDao).countPaySuccess(id) > 0;
    }

    @Override
    public void updateStatusToSuccess(String bankOrderId, BankType banktype) {
        ((BankPayLogDao)this.entityDao).updateStatusToSuccess(bankOrderId, banktype);
    }

    @Override
    public void updateStatusToFail(String bankOrderId, BankType banktype) {
        ((BankPayLogDao)this.entityDao).updateStatusToFail(bankOrderId, banktype);
    }

    private BankPayLogService getProxy() {
        return (BankPayLogService)AopContext.currentProxy();
    }

    @Override
    public boolean payCall(HttpServletRequest request, BankType bankType) {
        this.printMsg(request);
        boolean isOk = false;
        String orderno = null;
        switch (bankType) {
            case ALIPAY: {
                orderno = request.getParameter("out_trade_no");
                isOk = AlipayInterfaceHelper.isPaySuccess(request);
                break;
            }
            case CHINAPAY: {
                orderno = request.getParameter("orderno");
                isOk = ChinaPayInterfaceHelper.isPaySuccess(request);
                break;
            }
            case CHINABANK: {
                orderno = request.getParameter("v_oid");
                isOk = ChinaBankPayHelper.isPaySuccess(request);
                break;
            }
            case WECHAT: {
                try {
                    String xmlStr = IOUtils.toString((InputStream)request.getInputStream());
                    this.logger.info("\u5fae\u4fe1\u652f\u4ed8\u56de\u8c03\u8bf7\u6c42xml:{}", (Object)xmlStr);
                    NotifyResultParm result = XmlUtil.converyToJavaBean(xmlStr, NotifyResultParm.class);
                    isOk = WxpayHelper.isPaySuccess(result);
                    orderno = result.getOutTradeNo();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case KUAIQIAN: {
                orderno = request.getParameter("orderId");
                isOk = KuaiQianPayHelper.isPaySuccess(request);
            }
        }
        if (StringUtils.isBlank(orderno)) {
            this.logger.info("\u8ba2\u5355\u53f7\u4e3a\u7a7a ");
            return false;
        }
        this.getProxy().operatePayResult(bankType, isOk, orderno);
        this.logger.info("\u652f\u4ed8\u7ed3\u679c:{}", (Object)isOk);
        return isOk;
    }

    @Override
    @Transactional
    public void operatePayResult(BankType bankType, boolean payStatus, String outTradeNo) {
        BankPaylog bankPaylog = ((BankPayLogDao)this.entityDao).findByBankOrderIdAndBankType(outTradeNo, bankType);
        if (bankPaylog != null) {
            if (payStatus) {
                this.updateStatusToSuccess(outTradeNo, bankType);
                this.orderItemService.updateOrderState(Long.valueOf(bankPaylog.getSelfOrderId()), OrderItem.Status.PAID, OrderItem.AdmStatus.PAID, null);
            } else {
                this.updateStatusToFail(outTradeNo, bankType);
                this.orderItemService.updateOrderState(Long.valueOf(bankPaylog.getSelfOrderId()), OrderItem.Status.NOT_PAID, OrderItem.AdmStatus.NOT_PAID, null);
            }
        }
    }

    private void printMsg(HttpServletRequest request) {
        StringBuilder sb = new StringBuilder();
        Map requestParams = request.getParameterMap();
        for (String name : requestParams.keySet()) {
            String[] values = (String[])requestParams.get(name);
            String valueStr = "";
            for (int i = 0; i < values.length; ++i) {
                valueStr = i == values.length - 1 ? valueStr + values[i] : valueStr + values[i] + ",";
            }
            this.logger.info("{}------\u8f6c\u7801\u524d:{}", (Object)name, (Object)valueStr);
        }
    }
}

