/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.service.impl;

import com.google.common.collect.Maps;
import com.rocoinfo.rocomall.common.service.CrudService;
import com.rocoinfo.rocomall.common.service.ServiceException;
import com.rocoinfo.rocomall.entity.Address;
import com.rocoinfo.rocomall.entity.dict.DictProviceCity;
import com.rocoinfo.rocomall.repository.AddressDao;
import com.rocoinfo.rocomall.service.IAddressService;
import com.rocoinfo.rocomall.service.dict.IDictProviceCityService;
import com.rocoinfo.rocomall.service.order.IOrderService;
import com.rocoinfo.rocomall.utils.ValidateUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Caching;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springside.modules.utils.Collections3;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
@Transactional
public class AddressService
extends CrudService<AddressDao, Address>
implements IAddressService {
    @Autowired
    private IOrderService orderService;
    @Autowired
    private IDictProviceCityService dictService;

    @Override
    public void insert(Address address) {
        if (address != null) {
            if (!ValidateUtils.isMobile(address.getMobile())) {
                throw new ServiceException("\u6536\u8d27\u4eba\u624b\u673a\u53f7\u4e0d\u5408\u6cd5: " + address.getMobile());
            }
            super.insert(address);
            if (address.isDefaultAddr()) {
                this.setDefaultAddress(address.getId(), address.getUser().getId());
            }
        }
    }

    @Override
    public void update(Address address) {
        if (address != null) {
            if (!ValidateUtils.isMobile(address.getMobile())) {
                throw new ServiceException("\u6536\u8d27\u4eba\u624b\u673a\u53f7\u4e0d\u5408\u6cd5: " + address.getMobile());
            }
            super.update(address);
            if (address.isDefaultAddr()) {
                this.setDefaultAddress(address.getId(), address.getUser().getId());
            }
        }
    }

    @Override
    @Caching(evict={@CacheEvict(value={"cache"}, key="'cache.address.'+#addrId"), @CacheEvict(value={"cache"}, key="'cache.address.all'")})
    public void removeUserAddress(Long addrId, Long userId) {
        if (userId > 0L && addrId > 0L) {
            HashMap paramMap = Maps.newHashMapWithExpectedSize((int)2);
            paramMap.put("id", addrId);
            paramMap.put("userId", userId);
            ((AddressDao)this.entityDao).removeUserAddress(paramMap);
        }
    }

    @Override
    public List<Address> findUserAddressList(Long userId, Boolean visiable) {
        List<Address> addrList = Collections.emptyList();
        if (userId > 0L) {
            HashMap params = Maps.newHashMap();
            params.put("userId", userId);
            if (visiable != null) {
                params.put("visiable", visiable);
            }
            addrList = ((AddressDao)this.entityDao).findUserAddressList(params);
        }
        return addrList;
    }

    @Override
    public void buildProvCityCounty(List<Address> addressLists) {
        Iterator<Address> it = addressLists.iterator();
        while (it.hasNext()) {
            if (it.next() != null) continue;
            it.remove();
        }
        if (!CollectionUtils.isEmpty(addressLists)) {
            Map<Long, List<DictProviceCity>> addrPrefixMap = this.dictService.buildParentProvCityNodeTree(false, addressLists.toArray(new Address[0]));
            for (Address address : addressLists) {
                address.setProviceCityList(addrPrefixMap.get(address.getId()));
            }
        }
    }

    @Override
    @Caching(evict={@CacheEvict(value={"cache"}, key="'cache.address.'+#defAddrId"), @CacheEvict(value={"cache"}, key="'cache.address.all'")})
    public void setDefaultAddress(Long defAddrId, Long userId) {
        if (userId > 0L && defAddrId > 0L) {
            HashMap paramMap = Maps.newHashMapWithExpectedSize((int)2);
            paramMap.put("id", defAddrId);
            paramMap.put("userId", userId);
            ((AddressDao)this.entityDao).setDefaultAddress(paramMap);
        }
    }

    @Override
    public List<Address> getAddressAndBuildProvCityCounty(Long userId) {
        List<Address> addressList = this.findUserAddressList(userId, null);
        if (Collections3.isNotEmpty(addressList)) {
            this.buildProvCityCounty(addressList);
        }
        return addressList;
    }
}

