/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.service.impl;

import com.rocoinfo.rocomall.common.service.CrudService;
import com.rocoinfo.rocomall.entity.Attention;
import com.rocoinfo.rocomall.entity.Sku;
import com.rocoinfo.rocomall.repository.AttentionDao;
import com.rocoinfo.rocomall.service.IAttentionService;
import com.rocoinfo.rocomall.service.product.ISkuService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class AttentionService
extends CrudService<AttentionDao, Attention>
implements IAttentionService {
    @Autowired
    private ISkuService skuService;

    @Override
    public Page<Sku> queryAttentionList(Map<String, Object> params, PageRequest pageable) {
        params.put("offset", pageable.getOffset());
        params.put("pageSize", pageable.getPageSize());
        params.put("sort", pageable.getSort());
        List<Map> attentions = ((AttentionDao)this.entityDao).queryAttentionList(params);
        Long count = ((AttentionDao)this.entityDao).queryTotal(params);
        ArrayList<Sku> skus = new ArrayList<Sku>();
        for (Map attention : attentions) {
            Sku sku = (Sku)this.skuService.getById(((Integer)attention.get("skuId")).longValue());
            this.skuService.buildCartSkuDetail(sku);
            skus.add(sku);
        }
        return new PageImpl(skus, (Pageable)pageable, count.longValue());
    }
}

