/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.service.impl;

import com.google.common.collect.Maps;
import com.rocoinfo.rocomall.common.service.CrudService;
import com.rocoinfo.rocomall.entity.Address;
import com.rocoinfo.rocomall.entity.UserCatalogRelation;
import com.rocoinfo.rocomall.entity.account.User;
import com.rocoinfo.rocomall.entity.account.UserLevel;
import com.rocoinfo.rocomall.enumconst.SwitchStatus;
import com.rocoinfo.rocomall.enumconst.TTLUnit;
import com.rocoinfo.rocomall.repository.UserCatalogRelationDao;
import com.rocoinfo.rocomall.repository.account.UserDao;
import com.rocoinfo.rocomall.repository.cent.CentsDao;
import com.rocoinfo.rocomall.service.IUserService;
import com.rocoinfo.rocomall.service.impl.AddressService;
import com.rocoinfo.rocomall.service.impl.UserLevelService;
import com.rocoinfo.rocomall.utils.PasswordUtil;
import java.sql.Date;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springside.modules.utils.Collections3;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Transactional
public class UserService
extends CrudService<UserDao, User>
implements IUserService {
    @Autowired
    private AddressService addressService;
    @Autowired
    private UserLevelService userLevelService;
    @Autowired
    private UserCatalogRelationDao userCatalogRelationDao;
    @Autowired
    private CentsDao centDao;

    @Override
    public void updateLoginPassword(long userId, String newPlainPwd) {
        if (userId > 0L) {
            User user = new User(userId);
            user.setPlainPassword(newPlainPwd);
            PasswordUtil.entryptPassword(user);
            ((UserDao)this.entityDao).update(user);
        }
    }

    @Override
    public boolean isLoginPasswordCorrect(String username, String loginPassword) {
        User user = this.getUserByUsername(username);
        if (user == null || user.getPassword() == null || user.getSalt() == null || loginPassword == null) {
            return false;
        }
        return PasswordUtil.hashPassword(loginPassword, user.getSalt()).equals(user.getPassword());
    }

    @Override
    public boolean isUsernameRegisted(String username) {
        return this.getUserByUsername(username) != null;
    }

    @Override
    public int getGrowthById(Long userId) {
        Integer growth = ((UserDao)this.entityDao).getGrowthById(userId);
        return growth == null ? -1 : growth;
    }

    @Override
    public void increaseGrowthById(Long userId, int increment) {
        if (userId == null || userId < 1L || increment == 0) {
            throw new IllegalArgumentException("userId\u5fc5\u987b\u5927\u4e8e0");
        }
        ((UserDao)this.entityDao).increaseGrowthById(userId, increment);
    }

    @Override
    public int getCentBalanceByUserId(Long userId) {
        return this.getCentBalanceByUserIdAndTTL(userId, TTLUnit.DAY, 0);
    }

    @Override
    public int getCentBalanceByUserIdAndTTL(Long userId, TTLUnit ttlUnit, int amount) {
        HashMap params = Maps.newHashMap();
        params.put("userId", userId);
        if (amount > 0) {
            java.util.Date curDate = new java.util.Date();
            java.util.Date expireToDate = null;
            expireToDate = ttlUnit == TTLUnit.DAY ? DateUtils.addDays((java.util.Date)curDate, (int)amount) : DateUtils.addMonths((java.util.Date)curDate, (int)amount);
            params.put("expireToDate", new Date(expireToDate.getTime()));
        }
        return this.centDao.getCentBalanceByUserIdAndExpireTo(params);
    }

    @Override
    public UserLevel getUserLevelById(Long userId) {
        int growth = this.getGrowthById(userId);
        if (growth >= 0) {
            return this.userLevelService.getUserLevelByGrowth(growth);
        }
        return null;
    }

    @Override
    public User getUserByUsername(String username) {
        return ((UserDao)this.entityDao).getByUsername(username);
    }

    @Override
    public User getByMobile(String mobile) {
        return ((UserDao)this.entityDao).getByMobile(mobile);
    }

    @Override
    public Page<User> searchUser(java.util.Date registStartDate, java.util.Date registEndDate, String userNameOrName, String mobilePhone, SwitchStatus status, Pageable pageable) {
        HashMap parameters = Maps.newHashMap();
        if (registStartDate != null) {
            parameters.put("registStartDate", registStartDate);
        }
        if (registEndDate != null) {
            parameters.put("registEndDate", registEndDate);
        }
        if (status != null) {
            parameters.put("status", status);
        }
        if (StringUtils.isNotBlank((CharSequence)userNameOrName)) {
            parameters.put("userNameOrName", userNameOrName);
        }
        if (StringUtils.isNotBlank((CharSequence)mobilePhone)) {
            parameters.put("mobilePhone", mobilePhone);
        }
        parameters.put("sort", pageable.getSort());
        parameters.put("offset", pageable.getOffset());
        parameters.put("pageSize", pageable.getPageSize());
        long total = ((UserDao)this.entityDao).searchTotal(parameters);
        List users = Collections.emptyList();
        if (total > (long)pageable.getOffset()) {
            users = ((UserDao)this.entityDao).search(parameters);
        }
        return new PageImpl(users, pageable, total);
    }

    public void buildUserDetail(User user) {
        List<Address> addressList = this.addressService.findUserAddressList(user.getId(), null);
        if (Collections3.isNotEmpty(addressList)) {
            this.addressService.buildProvCityCounty(addressList);
            user.setAddressLists(addressList);
        }
    }

    @Override
    public void bindMobileByUserId(long userId, String mobile) {
        if (userId < 1L || StringUtils.isBlank((CharSequence)mobile)) {
            throw new IllegalArgumentException("userId\u5fc5\u987b\u5927\u4e8e\u96f6\u5e76\u4e14\uff0cmobile\u4e0d\u80fd\u4e3a\u7a7a");
        }
        User user = new User();
        user.setId(userId);
        user.setMobilePhone(mobile);
        super.update(user);
    }

    @Override
    public void switchUser(Long userId, SwitchStatus status) {
        User user = new User();
        user.setId(userId);
        user.setStatus(status);
        super.update(user);
    }

    @Override
    public List<Long> findCatalogIdsByUserId(Long loggedUserId) {
        return this.userCatalogRelationDao.findCatalogIdsByUserId(loggedUserId);
    }

    @Override
    public void personalSettingsSave(User user, Long[] catalogIds) {
        ((UserDao)this.entityDao).update(user);
        this.saveUserCatalogRelations(user.getId(), catalogIds);
    }

    private void saveUserCatalogRelations(Long userId, Long[] catalogIds) {
        this.userCatalogRelationDao.deleteByUserId(userId);
        if (!ArrayUtils.isEmpty((Object[])catalogIds)) {
            for (Long catalogid : catalogIds) {
                this.userCatalogRelationDao.insert(new UserCatalogRelation(userId, catalogid));
            }
        }
    }
}

