/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.service.impl.activity;

import com.google.common.collect.Lists;
import com.rocoinfo.rocomall.common.service.CrudService;
import com.rocoinfo.rocomall.common.service.ServiceException;
import com.rocoinfo.rocomall.entity.Brand;
import com.rocoinfo.rocomall.entity.Product;
import com.rocoinfo.rocomall.entity.Sku;
import com.rocoinfo.rocomall.entity.Supplier;
import com.rocoinfo.rocomall.entity.activity.Activity;
import com.rocoinfo.rocomall.entity.activity.ActivitySku;
import com.rocoinfo.rocomall.repository.activity.ActivityDao;
import com.rocoinfo.rocomall.repository.activity.ActivityRecordDao;
import com.rocoinfo.rocomall.service.activity.IActivityService;
import com.rocoinfo.rocomall.service.activity.IActivitySkuService;
import com.rocoinfo.rocomall.service.product.IBrandService;
import com.rocoinfo.rocomall.service.product.IDescriptionService;
import com.rocoinfo.rocomall.service.product.IProductCatalogService;
import com.rocoinfo.rocomall.service.product.IProductImageService;
import com.rocoinfo.rocomall.service.product.IProductService;
import com.rocoinfo.rocomall.service.product.ISkuService;
import com.rocoinfo.rocomall.service.product.ISupplierService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.AopContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springside.modules.utils.Collections3;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class ActivityService
extends CrudService<ActivityDao, Activity>
implements IActivityService {
    private static Logger logger = LoggerFactory.getLogger(ActivityService.class);
    @Autowired
    private IActivitySkuService activitySkuService;
    @Autowired
    private ISkuService skuService;
    @Autowired
    private IProductImageService productImageService;
    @Autowired
    private IProductService productService;
    @Autowired
    private ISupplierService supplierService;
    @Autowired
    private IBrandService brandService;
    @Autowired
    private IDescriptionService descriptionService;
    @Autowired
    private IProductCatalogService productCatalogService;
    @Autowired
    private ActivityRecordDao activityRecordDao;

    @Override
    @Transactional(isolation=Isolation.READ_COMMITTED, propagation=Propagation.REQUIRED)
    public void insert(Activity activity) {
        if (activity == null) {
            throw new ServiceException("\u6d3b\u52a8\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (((ActivityDao)this.entityDao).findByActivityName(activity.getName(), null) != null) {
            throw new ServiceException("\u6d3b\u52a8\u540d\u79f0\u5df2\u7ecf\u5b58\u5728");
        }
        if (!activity.getEndTime().after(activity.getStartTime())) {
            throw new ServiceException("\u7ed3\u675f\u65f6\u95f4\u5e94\u8be5\u5927\u4e8e\u5f00\u59cb\u65f6\u95f4");
        }
        if (!activity.getEndTime().after(new Date())) {
            throw new ServiceException("\u7ed3\u675f\u65f6\u95f4\u5e94\u8be5\u5927\u4e8e\u5f53\u524d\u65f6\u95f4");
        }
        activity.setStatus(Activity.Status.DRAFT);
        ((ActivityDao)this.entityDao).insert(activity);
        if (activity.getType() == Activity.Type.SCRAPE_CARD || activity.getType() == Activity.Type.TURN_TABLE) {
            this.activityRecordDao.initActivityTotalCent(activity.getId());
        }
        for (ActivitySku activitySku : activity.getActivitySkus()) {
            if (activitySku == null || activitySku.getSku() == null) continue;
            activitySku.setActivity(activity);
            this.activitySkuService.insert(activitySku);
        }
    }

    public boolean isActivityJoinable(Long id) {
        Activity activity = this.getProxy().getById(id);
        if (activity == null) {
            return false;
        }
        if (activity.getStatus() != Activity.Status.LIST) {
            return false;
        }
        List<ActivitySku> activitySkuList = this.activitySkuService.findByActivityId(id);
        return this.isStockEnoughOfActivity(activitySkuList);
    }

    public boolean isStockEnoughOfActivity(List<ActivitySku> activitySkuList) {
        if (CollectionUtils.isEmpty(activitySkuList)) {
            return false;
        }
        for (ActivitySku activitySku : activitySkuList) {
            Sku sku = (Sku)this.skuService.getById(activitySku.getSku().getId());
            if (sku.getAvailableStockQuantity() >= activitySku.getCount()) continue;
            return false;
        }
        return true;
    }

    @Override
    @Cacheable(value={"cache"}, key="'cache.activity.'+#id")
    public Activity getById(Long id) {
        return (Activity)((ActivityDao)this.entityDao).getById(id);
    }

    public List<Activity> findByIdIn(List<Long> ids) {
        if (Collections3.isEmpty(ids)) {
            return Collections.emptyList();
        }
        return ((ActivityDao)this.entityDao).findByIdIn(ids);
    }

    public void buildDetail(Activity activity) {
        if (activity == null) {
            return;
        }
        List<ActivitySku> activitySkus = this.activitySkuService.findByActivityId(activity.getId());
        activity.setActivitySkus(activitySkus);
        for (ActivitySku activitySku : activitySkus) {
            activitySku.setSku((Sku)this.skuService.getById(activitySku.getSku().getId()));
            Sku sku = activitySku.getSku();
            sku.setProductImages(this.productImageService.getBySkuId(sku.getId()));
            if (sku.getProduct() == null) continue;
            Product product = (Product)this.productService.getById(sku.getProduct().getId());
            sku.setProduct(product);
            product.setSupplier((Supplier)this.supplierService.getById(product.getSupplier().getId()));
            product.setBrand((Brand)this.brandService.getById(product.getBrand().getId()));
            product.setCatalogs(this.productCatalogService.findCatalogByProductId(product.getId()));
            product.setDescription(this.descriptionService.findByProductId(product.getId()));
            product.setProductImages(this.productImageService.getProductPrimaryImages(product.getId()));
        }
    }

    @Deprecated
    public void buildDetail(List<Activity> activities) {
        for (Activity activity : activities) {
            this.buildDetail(activity);
        }
    }

    @Deprecated
    public void buildCartActivityDetail(Activity activity) {
        List<ActivitySku> activitySkus = this.activitySkuService.findByActivityId(activity.getId());
        activity.setActivitySkus(activitySkus);
        for (ActivitySku activitySku : activitySkus) {
            activitySku.setActivity(activity);
            activitySku.setSku((Sku)this.skuService.getById(activitySku.getSku().getId()));
            Sku sku = activitySku.getSku();
            sku.setProductImages(this.productImageService.getBySkuId(sku.getId()));
            if (sku.getProduct() == null) continue;
            Product product = (Product)this.productService.getById(sku.getProduct().getId());
            sku.setProduct(product);
            product.setSupplier((Supplier)this.supplierService.getById(product.getSupplier().getId()));
            product.setProductImages(this.productImageService.getProductPrimaryImages(product.getId()));
        }
    }

    @Override
    @CacheEvict(value={"cache"}, key="'cache.activity.'+#activity.id")
    @Transactional(isolation=Isolation.READ_COMMITTED, propagation=Propagation.REQUIRED)
    public void update(Activity activity) {
        Activity oldActivity = this.getById(activity.getId());
        if (((ActivityDao)this.entityDao).findByActivityName(activity.getName(), activity.getId()) != null) {
            throw new ServiceException("\u6d3b\u52a8\u540d\u79f0\u5df2\u7ecf\u5b58\u5728");
        }
        if (oldActivity.getStatus() != Activity.Status.DRAFT && oldActivity.getStatus() != Activity.Status.REFUSE) {
            throw new ServiceException("\u5f53\u524d\u72b6\u6001\u4e3a " + oldActivity.getStatus().getLabel() + ",\u6d3b\u52a8\u4e0d\u5141\u8bb8\u7f16\u8f91");
        }
        if (!activity.getEndTime().after(activity.getStartTime())) {
            throw new ServiceException("\u7ed3\u675f\u65f6\u95f4\u5e94\u8be5\u5927\u4e8e\u5f00\u59cb\u65f6\u95f4");
        }
        if (!activity.getEndTime().after(new Date())) {
            throw new ServiceException("\u7ed3\u675f\u65f6\u95f4\u5e94\u8be5\u5927\u4e8e\u5f53\u524d\u65f6\u95f4");
        }
        activity.setStatus(Activity.Status.DRAFT);
        ((ActivityDao)this.entityDao).update(activity);
        if (activity.getActivitySkus() != null) {
            List newActivitySkuIds = Collections3.extractToList(activity.getActivitySkus(), (String)"id");
            List<ActivitySku> oldActivitySkus = this.activitySkuService.findByActivityId(activity.getId());
            for (ActivitySku oldActivitySku : oldActivitySkus) {
                if (newActivitySkuIds.contains(oldActivitySku.getId())) continue;
                this.activitySkuService.deleteById(oldActivitySku.getId());
            }
            for (ActivitySku activitySku : activity.getActivitySkus()) {
                if (activitySku == null || activitySku.getSku() == null) continue;
                activitySku.setActivity(activity);
                if (activitySku.getId() == null) {
                    this.activitySkuService.insert(activitySku);
                    continue;
                }
                this.activitySkuService.update(activitySku);
            }
        }
    }

    @CacheEvict(value={"cache"}, key="'cache.activity.'+#id")
    public void updateStatus(Long id, Activity.Status status) {
        ((ActivityDao)this.entityDao).updateStatus(id, status);
    }

    @CacheEvict(value={"cache"}, key="'cache.activity.'+#id")
    public void updateDelistTime(Long id, Date delistTime) {
        ((ActivityDao)this.entityDao).updateDelistTime(id, delistTime);
    }

    @CacheEvict(value={"cache"}, key="'cache.activity.'+#id")
    public void delete(Long id) {
        this.activitySkuService.deleteByActivityId(id);
        ((ActivityDao)this.entityDao).deleteById(id);
    }

    public Page<Activity> adminSearch(Map<String, Object> params, Pageable pageable) {
        List<Object> activitys;
        Long total = ((ActivityDao)this.entityDao).searchTotal(params);
        if (total > (long)pageable.getOffset()) {
            params.put("offset", pageable.getOffset());
            params.put("pageSize", pageable.getPageSize());
            params.put("sort", pageable.getSort());
            activitys = ((ActivityDao)this.entityDao).search(params);
        } else {
            activitys = Collections.emptyList();
        }
        return new PageImpl(activitys, pageable, total.longValue());
    }

    @CacheEvict(value={"cache"}, key="'cache.activity.'+#id")
    private void changeStatus(long id, Activity.Status newStatus) {
        Activity activity = this.getById(id);
        if (activity.getStatus() != newStatus) {
            if (Activity.Status.isAllowChangeStatus(activity.getStatus(), newStatus)) {
                Activity activity1 = new Activity();
                activity1.setId(id);
                activity1.setStatus(newStatus);
                ((ActivityDao)this.entityDao).update(activity1);
            } else {
                throw new ServiceException("\u6d3b\u52a8\u72b6\u6001\u4e0d\u80fd\u4ece " + activity.getStatus().getLabel() + " \u6539\u4e3a " + newStatus.getLabel());
            }
        }
    }

    @CacheEvict(value={"cache"}, key="'cache.activity.'+#id")
    public void discard(Long id) {
        this.changeStatus(id, Activity.Status.DISCARD);
    }

    @CacheEvict(value={"cache"}, key="'cache.activity.'+#id")
    public void submitAudit(Long id) {
        this.changeStatus(id, Activity.Status.AUDIT);
    }

    @CacheEvict(value={"cache"}, key="'cache.activity.'+#id")
    public void auditRefuse(Long id) {
        this.changeStatus(id, Activity.Status.REFUSE);
    }

    @CacheEvict(value={"cache"}, key="'cache.activity.'+#id")
    public void auditOk(Long id) {
        this.changeStatus(id, Activity.Status.READY_LIST);
    }

    @CacheEvict(value={"cache"}, key="'cache.activity.'+#id")
    public void delist(Long id) {
        List<ActivitySku> activitySkus = this.activitySkuService.findByActivityId(id);
        block0: for (ActivitySku actSku : activitySkus) {
            List<Activity> exclusiveActivitys = this.activitySkuService.getExclusiveActivityCountByskuId(actSku.getSku().getId());
            List activityIds = null;
            boolean iscontain = false;
            if (CollectionUtils.isEmpty(exclusiveActivitys)) continue;
            activityIds = Collections3.extractToList(exclusiveActivitys, (String)"id");
            for (Long aid : activityIds) {
                if (!StringUtils.equals((CharSequence)String.valueOf(aid), (CharSequence)String.valueOf(id))) continue;
                iscontain = true;
                continue block0;
            }
        }
        this.changeStatus(id, Activity.Status.DELIST);
    }

    @CacheEvict(value={"cache"}, key="'cache.activity.'+#id")
    public void list(Long id) {
        this.list(this.getById(id), null);
    }

    @CacheEvict(value={"cache"}, key="'cache.activity.'+#activity.id")
    public void list(Activity activity, Long userId) {
        if ((activity.getType() == Activity.Type.SCRAPE_CARD || activity.getType() == Activity.Type.TURN_TABLE) && this.findActivityByStatusAndType(Activity.Status.LIST, activity.getType()) != null) {
            throw new ServiceException("\u5df2\u7ecf\u5b58\u5728\u4e00\u4e2a\u4e0a\u67b6\u7684" + activity.getType().getLabel() + "\u6d3b\u52a8");
        }
        if (!Activity.Status.isAllowChangeStatus(activity.getStatus(), Activity.Status.LIST)) {
            throw new ServiceException("\u6d3b\u52a8\u72b6\u6001\u4e0d\u80fd\u4ece " + activity.getStatus().getLabel() + " \u6539\u4e3a " + Activity.Status.LIST.getLabel());
        }
        this.buildActivityDetail(Lists.newArrayList((Object[])new Activity[]{activity}), false);
        List<Long> productIds = this.activitySkuService.findProductIdByActivityId(activity.getId());
        for (Long productId : productIds) {
            Product product = (Product)this.productService.getById(productId);
            if (product.getStatus() != Product.Status.LIST) {
                throw new ServiceException("\u5546\u54c1\u672a\u4e0a\u67b6(\u8bf7\u5148\u4e0a\u67b6\u8be5\u5546\u54c1). \u5546\u54c1\u540d\u79f0=" + product.getName());
            }
            Date endTime = product.getDelistTime();
            if (endTime == null || !activity.getEndTime().after(product.getDelistTime())) continue;
            throw new ServiceException("\u5546\u54c1\u4e0b\u67b6\u65f6\u95f4\u4e0d\u80fd\u65e9\u4e8e\u6d3b\u52a8\u4e0b\u67b6\u65f6\u95f4(\u8bf7\u5ef6\u957f\u5546\u54c1\u4e0b\u67b6\u65f6\u95f4).\u5546\u54c1\u540d\u79f0=" + product.getName());
        }
        List<ActivitySku> activitySkus = activity.getActivitySkus();
        for (ActivitySku activitySku : activitySkus) {
            Sku sku = activitySku.getSku();
            if (activity.getType() != Activity.Type.AUCTION && sku.getAvailableStockQuantity() <= 0) {
                throw new ServiceException("\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3(\u8bf7\u5148\u6dfb\u52a0\u5546\u54c1\u5e93\u5b58).\u5546\u54c1\u7f16\u7801=" + activitySku.getSku().getCode());
            }
            if (sku.getStatus() == Sku.Status.ENABLED) continue;
            throw new ServiceException("\u5546\u54c1\u672a\u542f\u7528(\u8bf7\u5148\u542f\u7528\u8be5\u5546\u54c1).\u5546\u54c1\u7f16\u7801=" + activitySku.getSku().getCode());
        }
        Activity updateActivity = new Activity();
        updateActivity.setId(activity.getId());
        updateActivity.setStatus(Activity.Status.LIST);
        ((ActivityDao)this.entityDao).update(updateActivity);
    }

    @Deprecated
    public boolean isProductAllList(Activity activity) {
        List<Long> productIds = this.activitySkuService.findProductIdByActivityId(activity.getId());
        for (Long productId : productIds) {
            Product product = (Product)this.productService.getById(productId);
            if (product.getStatus() == Product.Status.LIST) continue;
            return false;
        }
        return true;
    }

    @CacheEvict(value={"cache"}, key="'cache.activity.'+#activity.id")
    @Transactional(isolation=Isolation.SERIALIZABLE, propagation=Propagation.REQUIRED)
    public void delist(Activity activity, Long userId) {
        if (!Activity.Status.isAllowChangeStatus(activity.getStatus(), Activity.Status.DELIST)) {
            throw new ServiceException("\u6d3b\u52a8\u72b6\u6001\u4e0d\u80fd\u4ece " + activity.getStatus().getLabel() + " \u6539\u4e3a " + Activity.Status.LIST.getLabel());
        }
        Activity activity1 = new Activity();
        activity1.setId(activity.getId());
        activity1.setStatus(Activity.Status.DELIST);
        ((ActivityDao)this.entityDao).update(activity1);
    }

    public List<Activity> findListableTopActivitysGroupByType() {
        List<Activity> topActivityList = ((ActivityDao)this.entityDao).findListableTopActivitysGroupByType(new Date());
        if (!CollectionUtils.isEmpty(topActivityList)) {
            this.buildActivityDetail(topActivityList, true);
            return topActivityList;
        }
        return Collections.EMPTY_LIST;
    }

    public List<Activity> findActivitysByStatusAndType(Activity.Status status, Activity.Type type) {
        return ((ActivityDao)this.entityDao).findActivityByStatusAndType(status, type);
    }

    public Activity findActivityByStatusAndType(Activity.Status status, Activity.Type type) {
        return (Activity)Collections3.getFirst(this.findActivitysByStatusAndType(status, type));
    }

    private ActivityService getProxy() {
        return (ActivityService)AopContext.currentProxy();
    }

    public Page<Activity> search(Map<String, Object> params, Pageable pageable) {
        List<Activity> activitys = Collections.emptyList();
        Long total = ((ActivityDao)this.entityDao).searchTotal(params);
        if (total > (long)pageable.getOffset()) {
            params.put("offset", pageable.getOffset());
            params.put("pageSize", pageable.getPageSize());
            params.put("sort", pageable.getSort());
            activitys = ((ActivityDao)this.entityDao).search(params);
            this.buildActivityDetail(activitys, true);
        }
        return new PageImpl(activitys, pageable, total.longValue());
    }

    public void buildActivityDetail(List<Activity> activitys, boolean isLoadImg) {
        if (!CollectionUtils.isEmpty(activitys)) {
            Map<Long, List<ActivitySku>> skuListMap = this.activitySkuService.findListMapByActivityIdIn(Collections3.extractToList(activitys, (String)"id"));
            ArrayList loadImgSkuList = Lists.newArrayList();
            for (Activity activity : activitys) {
                activity.setActivitySkus(skuListMap.get(activity.getId()));
                if (CollectionUtils.isEmpty(activity.getActivitySkus())) continue;
                for (ActivitySku actSku : activity.getActivitySkus()) {
                    loadImgSkuList.add(actSku.getSku());
                }
            }
            if (isLoadImg) {
                this.skuService.loadImages(loadImgSkuList);
            }
        }
    }

    public List<Activity> findNeedCreateAuctionRefundRecodeActivity() {
        return ((ActivityDao)this.entityDao).findNeedCreateAuctionRefundRecodeActivity();
    }

    @Override
    public void buildActivityDetail(Activity activity, boolean isLoadImg) {
        if (activity != null) {
            Map<Long, List<ActivitySku>> skuListMap = this.activitySkuService.findListMapByActivityIdIn(Collections3.extractToList((Collection)Lists.newArrayList((Object[])new Activity[]{activity}), (String)"id"));
            ArrayList loadImgSkuList = Lists.newArrayList();
            activity.setActivitySkus(skuListMap.get(activity.getId()));
            if (!CollectionUtils.isEmpty(activity.getActivitySkus())) {
                for (ActivitySku actSku : activity.getActivitySkus()) {
                    loadImgSkuList.add(actSku.getSku());
                }
            }
            if (isLoadImg) {
                this.skuService.loadImages(loadImgSkuList);
            }
        }
    }
}

