/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.service.impl.cent;

import com.rocoinfo.rocomall.common.service.CrudService;
import com.rocoinfo.rocomall.dto.StatusDto;
import com.rocoinfo.rocomall.dto.admin.CentsImportExcelDto;
import com.rocoinfo.rocomall.entity.account.AdminUser;
import com.rocoinfo.rocomall.entity.account.User;
import com.rocoinfo.rocomall.entity.cent.CentApply;
import com.rocoinfo.rocomall.entity.cent.CentRule;
import com.rocoinfo.rocomall.entity.cent.Cents;
import com.rocoinfo.rocomall.repository.cent.CentApplyDao;
import com.rocoinfo.rocomall.repository.cent.CentsDao;
import com.rocoinfo.rocomall.service.IUserService;
import com.rocoinfo.rocomall.service.cent.ICentApplyService;
import com.rocoinfo.rocomall.service.cent.ICentRuleService;
import com.rocoinfo.rocomall.utils.CodeGenerator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Transactional(rollbackFor={Exception.class})
public class CentApplyService
extends CrudService<CentApplyDao, CentApply>
implements ICentApplyService {
    @Autowired
    private CentsDao centsDao;
    @Autowired
    private CodeGenerator codeGenerator;
    @Autowired
    private IUserService userService;
    @Autowired
    private ICentRuleService centRuleService;
    private static final int IMPORT_MAX_RECORD = 10000;

    @Override
    public StatusDto importCent(String ruleCode, List<CentsImportExcelDto> dataList, Long userid) {
        StatusDto statusDto = new StatusDto();
        statusDto.setCode("0");
        statusDto.setMessage("\u5bfc\u5165\u6210\u529f\uff01");
        if (ruleCode == null) {
            statusDto.setMessage("\u89c4\u5219\u7f16\u7801\u4e0d\u80fd\u80fd\u4e3a\u7a7a\uff01");
            return statusDto;
        }
        CentRule rule = this.centRuleService.getByCode(ruleCode);
        if (rule == null) {
            statusDto.setMessage("\u89c4\u5219\u7f16\u7801\u4e0d\u5b58\u5728\uff01");
            return statusDto;
        }
        ArrayList<Cents> centList = new ArrayList<Cents>();
        ArrayList<String> isHashCode = new ArrayList<String>();
        int countCent = 0;
        for (int i = 0; i < dataList.size(); ++i) {
            Cents cent = this.validateCentImport(i, dataList.get(i), statusDto, isHashCode, rule);
            if (cent == null) {
                return statusDto;
            }
            centList.add(cent);
            countCent += cent.getBalance().intValue();
        }
        Date date = new Date();
        CentApply apply = new CentApply();
        apply.setCreateTime(date);
        apply.setOperateTime(date);
        apply.setRuleCode(ruleCode);
        apply.setType(CentApply.Type.IMPORT);
        apply.setUser(new AdminUser(userid));
        apply.setTotalCent(countCent);
        apply.setTotalRecord(centList.size());
        ((CentApplyDao)this.entityDao).insertCentApply(apply);
        for (Cents c : centList) {
            c.setApplyId(apply.getId());
            this.centsDao.insert(c);
        }
        return StatusDto.buildDataSuccessStatusDto();
    }

    @Override
    public StatusDto manualAddUserCent(String ruleCode, String username, Integer cent, Date expireDate, Long loggedUserId) {
        CentApply apply = new CentApply();
        apply.setType(CentApply.Type.ADD);
        apply.setRuleCode(ruleCode);
        apply.setUser(new AdminUser(loggedUserId));
        apply.setTotalCent(cent);
        apply.setTotalRecord(1);
        apply.setOperateTime(new Date());
        ((CentApplyDao)this.entityDao).insertCentApply(apply);
        Cents cents = new Cents();
        cents.setApplyId(apply.getId());
        cents.setBalance(cent);
        cents.setCent(cent);
        cents.setRuleCode(ruleCode);
        CentRule centRule = new CentRule();
        centRule.setCode(ruleCode);
        cents.setCode(this.codeGenerator.generateCentCode(centRule));
        cents.setEffectiveDate(new Date());
        cents.setExpireDate(expireDate);
        cents.setUser(this.userService.getUserByUsername(username));
        cents.setStatus(Cents.Status.CANUSE);
        this.centsDao.insert(cents);
        return StatusDto.buildSuccessStatusDto("\u79ef\u5206\u53d1\u653e\u6210\u529f");
    }

    private Cents validateCentImport(Integer rowindex, CentsImportExcelDto dto, StatusDto statusDto, List<String> isHasCode, CentRule rule) {
        Cents cents = new Cents();
        if (StringUtils.isEmpty((CharSequence)dto.getPhone())) {
            statusDto.setMessage("\u5bfc\u5165\u5931\u8d25! \u7b2c" + (rowindex + 1) + "\u884c" + ": \u624b\u673a\u53f7\u4e0d\u53ef\u4e3a\u7a7a!");
            return null;
        }
        User user = this.userService.getByMobile(dto.getPhone());
        if (user == null) {
            statusDto.setMessage("\u5bfc\u5165\u5931\u8d25! \u7b2c" + (rowindex + 1) + "\u884c" + ": \u624b\u673a\u53f7\u4e0d\u53ef\u7528!");
            return null;
        }
        if (StringUtils.isEmpty((CharSequence)dto.getCentCode())) {
            statusDto.setMessage("\u5bfc\u5165\u5931\u8d25! \u7b2c" + (rowindex + 1) + "\u884c" + ": \u79ef\u5206\u7f16\u7801\u4e0d\u53ef\u4e3a\u7a7a!");
            return null;
        }
        if (isHasCode.contains(dto.getCentCode())) {
            statusDto.setMessage("\u5bfc\u5165\u5931\u8d25! \u7b2c" + (rowindex + 1) + "\u884c" + ": \u79ef\u5206\u7f16\u7801\u4e0d\u80fd\u91cd\u590d\u5bfc\u5165!");
            return null;
        }
        isHasCode.add(dto.getCentCode());
        Cents cent = this.centsDao.getByCode(dto.getCentCode());
        if (cent != null) {
            statusDto.setMessage("\u5bfc\u5165\u5931\u8d25! \u7b2c" + (rowindex + 1) + "\u884c" + ": \u79ef\u5206\u7f16\u7801\u5df2\u5b58\u5728!");
            return null;
        }
        Integer value = -1;
        try {
            value = Integer.valueOf(dto.getCent());
        }
        catch (Exception e) {
            statusDto.setMessage("\u5bfc\u5165\u5931\u8d25! \u7b2c" + (rowindex + 1) + "\u884c" + ": \u79ef\u5206\u5fc5\u987b\u4e3a\u6570\u5b57!");
            return null;
        }
        if (value < 0 || value > 99999) {
            statusDto.setMessage("\u5bfc\u5165\u5931\u8d25! \u7b2c" + (rowindex + 1) + "\u884c" + ": \u79ef\u5206\u503c\u5fc5\u987b\u662f\u5927\u4e8e0\u7684\u6574\u6570\uff0c\u6700\u5927\u4e0d\u80fd\u8d85\u8fc799999!");
            return null;
        }
        cents.setCode(dto.getCentCode());
        cents.setCent(value);
        cents.setBalance(value);
        cents.setEffectiveDate(rule.getEffectiveDate());
        cents.setExpireDate(new Date());
        cents.setStatus(Cents.Status.CANUSE);
        cents.setRuleCode(rule.getCode());
        cents.setUser(user);
        cents.setDateline(new Date());
        cents.setCreateTime(new Date());
        return cents;
    }

    private static String getValue(Cell cell) {
        if (cell == null) {
            return null;
        }
        if (cell.getCellType() == 4) {
            boolean val = cell.getBooleanCellValue();
            return String.valueOf(val);
        }
        if (cell.getCellType() == 0) {
            double val = cell.getNumericCellValue();
            return String.format("%.0f", val);
        }
        return StringUtils.trimToEmpty((String)cell.getStringCellValue());
    }

    @Override
    public Page<CentApply> searchScrollAddPage(Map<String, Object> params, Pageable pageable) {
        params.put("offset", pageable.getPageNumber());
        params.put("pageSize", pageable.getPageSize());
        params.put("sort", pageable.getSort());
        List<Object> pageData = Collections.emptyList();
        Long count = ((CentApplyDao)this.entityDao).searchAddTotal(params);
        if (count > 0L) {
            pageData = ((CentApplyDao)this.entityDao).searchAdd(params);
        }
        return new PageImpl(pageData, pageable, count.longValue());
    }
}

