/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.service.impl.cent;

import com.rocoinfo.rocomall.common.service.CrudService;
import com.rocoinfo.rocomall.entity.cent.CentConsumeDetail;
import com.rocoinfo.rocomall.entity.cent.CentConsumeRecord;
import com.rocoinfo.rocomall.repository.cent.CentConsumeDetailDao;
import com.rocoinfo.rocomall.repository.cent.CentConsumeRecordDao;
import com.rocoinfo.rocomall.service.cent.ICentConsumeRecordService;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class CentConsumeRecordService
extends CrudService<CentConsumeRecordDao, CentConsumeRecord>
implements ICentConsumeRecordService {
    @Autowired
    private CentConsumeDetailDao centConsumeDetailDao;

    @Transactional
    public void save(CentConsumeRecord consumeRecord) {
        super.insert(consumeRecord);
        if (CollectionUtils.isNotEmpty(consumeRecord.getCentDetails())) {
            this.centConsumeDetailDao.insert(consumeRecord.getCentDetails());
        }
    }

    @Override
    public List<CentConsumeDetail> findCentConsumeDetailByRecordId(Long recordId) {
        return this.centConsumeDetailDao.findCentConsumeDetailByRecordId(recordId);
    }

    @Override
    public Page<CentConsumeRecord> searchScrollPageByRuleCode(Map<String, Object> params, PageRequest pageable) {
        params.put("offset", pageable.getPageNumber());
        params.put("pageSize", pageable.getPageSize());
        params.put("sort", pageable.getSort());
        List<Object> pageData = Collections.emptyList();
        Long count = ((CentConsumeRecordDao)this.entityDao).searchTotalByRuleCode(params);
        if (count > 0L) {
            pageData = ((CentConsumeRecordDao)this.entityDao).searchByRuleCode(params);
        }
        return new PageImpl(pageData, (Pageable)pageable, count.longValue());
    }

    public List<CentConsumeDetail> findCentConsumeRecordAndDetailByCentId(Long centId) {
        return this.centConsumeDetailDao.findCentConsumeRecordAndDetailByCentId(centId);
    }
}

