/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.service.impl.cent;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.rocoinfo.rocomall.common.service.CrudService;
import com.rocoinfo.rocomall.dto.DeductParam;
import com.rocoinfo.rocomall.dto.RefundParam;
import com.rocoinfo.rocomall.dto.StatusDto;
import com.rocoinfo.rocomall.entity.account.User;
import com.rocoinfo.rocomall.entity.cent.CentConsumeDetail;
import com.rocoinfo.rocomall.entity.cent.CentConsumeRecord;
import com.rocoinfo.rocomall.entity.cent.Cents;
import com.rocoinfo.rocomall.entity.dict.DictCentConsumeType;
import com.rocoinfo.rocomall.entity.dict.DictPlatform;
import com.rocoinfo.rocomall.redis.RedissonTemplate;
import com.rocoinfo.rocomall.repository.cent.CentApplyDetailDao;
import com.rocoinfo.rocomall.repository.cent.CentConsumeDetailDao;
import com.rocoinfo.rocomall.repository.cent.CentConsumeRecordDao;
import com.rocoinfo.rocomall.repository.cent.CentsDao;
import com.rocoinfo.rocomall.service.cent.ICentsService;
import com.rocoinfo.rocomall.service.impl.cent.CentConsumeRecordService;
import com.rocoinfo.rocomall.utils.CodeGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.redisson.core.RLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class CentsService
extends CrudService<CentsDao, Cents>
implements ICentsService {
    private Logger log = LoggerFactory.getLogger(CentsService.class);
    @Autowired
    private CentConsumeRecordService consumeRecordService;
    @Autowired
    private CentConsumeRecordDao centConsumeRecordDao;
    @Autowired
    private CentConsumeDetailDao consumeDetailDao;
    @Autowired
    private RedissonTemplate redissonTemplate;
    @Autowired
    private CentApplyDetailDao centApplyDetailDao;
    @Autowired
    private CodeGenerator codeGenerator;

    public Cents getCentByCode(String code) {
        return ((CentsDao)this.entityDao).getByCode(code);
    }

    public List<String> findExistCentCodes(List<String> codeList) {
        return ((CentsDao)this.entityDao).findExistCentCodes(codeList);
    }

    public void scheduleExpireCent(Date limitTime) {
        ((CentsDao)this.entityDao).scheduleExpireCent(limitTime);
    }

    @Override
    public void refundCent(RefundParam refundParam) {
        Date dateline = new Date();
        int refundCent = refundParam.getCent();
        User user = new User(refundParam.getUserId());
        CentConsumeRecord refundConsumeRecord = new CentConsumeRecord();
        refundConsumeRecord.setConsumeType(new DictCentConsumeType(refundParam.getConsumeTypeCode()));
        refundConsumeRecord.setUser(user);
        refundConsumeRecord.setEntityId(refundParam.getEntityId());
        CentConsumeRecord consumedRecord = this.centConsumeRecordDao.getSingle(refundConsumeRecord);
        List<CentConsumeDetail> consumeDetails = this.consumeDetailDao.findCanRefundConsumeDetailByRcrdIdOrderByExpireDateDesc(consumedRecord.getId());
        HashMap refundedCentValueMap = Maps.newHashMap();
        HashMap centIncrMap = Maps.newHashMap();
        ArrayList refundDetailList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(consumeDetails) && refundCent > 0) {
            int itemRefundCent;
            int j = consumeDetails.size();
            for (int i = 0; i < j && refundCent > 0; refundCent -= itemRefundCent, ++i) {
                CentConsumeDetail detail = consumeDetails.get(i);
                itemRefundCent = Math.min(refundCent, detail.getAvaiableRefundCent());
                refundedCentValueMap.put(detail.getId(), itemRefundCent);
                centIncrMap.put(detail.getCent().getId(), itemRefundCent);
                CentConsumeDetail refundDetail = new CentConsumeDetail();
                refundDetail.setCent(detail.getCent());
                refundDetail.setCentAmt(-itemRefundCent);
                refundDetail.setRefundAmt(0);
                refundDetail.setRecord(refundConsumeRecord);
                refundDetailList.add(refundDetail);
            }
            if (CollectionUtils.isNotEmpty((Collection)refundDetailList)) {
                refundConsumeRecord.setSnNum(this.codeGenerator.generateCentConsumeSnNum(dateline, refundParam.getConsumeTypeCode()));
                refundConsumeRecord.setCentDetails(refundDetailList);
                refundConsumeRecord.setDateline(dateline);
                refundConsumeRecord.setPlatform(DictPlatform.CENT_PLATFORM);
                refundConsumeRecord.setStatus(CentConsumeRecord.Status.REFUND);
                refundConsumeRecord.setConsumeCent(-refundParam.getCent());
                refundConsumeRecord.setConsumeType(DictCentConsumeType.REFUND_CONSUME_TYPE);
                this.consumeRecordService.save(refundConsumeRecord);
                for (Map.Entry entry : centIncrMap.entrySet()) {
                    ((CentsDao)this.entityDao).incrBalanceAndUpdateToCanUse((Long)entry.getKey(), (Integer)entry.getValue());
                }
                for (Map.Entry entry : refundedCentValueMap.entrySet()) {
                    this.consumeDetailDao.incrRefundAmt((Long)entry.getKey(), (Integer)entry.getValue());
                }
            }
        }
    }

    @Override
    @Transactional(readOnly=true)
    public Page<Cents> searchHistCents(Map<String, Object> parameters, Pageable pageable) {
        long total = ((CentsDao)this.entityDao).searchTotal(parameters);
        List content = Collections.emptyList();
        if (total > (long)pageable.getOffset()) {
            parameters.put("offset", pageable.getOffset());
            parameters.put("pageSize", pageable.getPageSize());
            parameters.put("sort", pageable.getSort());
            content = ((CentsDao)this.entityDao).search(parameters);
        }
        return new PageImpl(content, pageable, total);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(isolation=Isolation.READ_COMMITTED, propagation=Propagation.REQUIRED)
    public StatusDto<String> deductCent(DeductParam param, Long loggedUserId) {
        RLock rLock = this.redissonTemplate.getDistributeLock(loggedUserId + "");
        String msg = "";
        try {
            rLock.lock();
            if (param == null) {
                StatusDto<String> statusDto = StatusDto.buildFailureStatusDto("\u6263\u79ef\u5206\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a!");
                return statusDto;
            }
            List<Cents> centList = ((CentsDao)this.entityDao).findCanUseCentOrderByExpireDateOfUser(param.getUserId());
            if (CollectionUtils.isEmpty(centList)) {
                StatusDto<String> statusDto = StatusDto.buildFailureStatusDto("\u60a8\u8d26\u6237\u6ca1\u6709\u4efb\u4f55\u53ef\u7528\u79ef\u5206!");
                return statusDto;
            }
            this.log.info("\u79ef\u5206\u6263\u51cf\u53c2\u6570\uff1a{}", (Object)param.toString());
            int deductCent = param.getCent();
            int availableTotalCent = 0;
            HashMap centUsedMap = Maps.newHashMap();
            for (Cents cents : centList) {
                int curCardDeductCent = Math.min(cents.getBalance(), deductCent);
                availableTotalCent += curCardDeductCent;
                centUsedMap.put(cents, curCardDeductCent);
                if ((deductCent -= curCardDeductCent) != 0) continue;
                break;
            }
            if (availableTotalCent != param.getCent()) {
                String error = "\u5269\u4f59\u79ef\u5206\u4e0d\u8db3\uff0c\u5269\u4f59\uff1a" + availableTotalCent;
                this.log.debug("\u7528\u6237[" + param.getUserId() + "]" + error);
                StatusDto<String> statusDto = StatusDto.buildFailureStatusDto(error);
                return statusDto;
            }
            ArrayList consumeDetailList = Lists.newArrayListWithExpectedSize((int)centUsedMap.size());
            Date date = new Date();
            CentConsumeRecord consumeRecord = new CentConsumeRecord();
            consumeRecord.setDateline(date);
            consumeRecord.setSnNum(this.codeGenerator.generateCentConsumeSnNum(date, param.getConsumeTypeCode()));
            consumeRecord.setConsumeType(new DictCentConsumeType(param.getConsumeTypeCode()));
            consumeRecord.setPlatform(new DictPlatform(param.getPlatformCode()));
            consumeRecord.setConsumeCent(param.getCent());
            consumeRecord.setStatus(CentConsumeRecord.Status.CONSUME);
            consumeRecord.setUser(new User(param.getUserId()));
            consumeRecord.setEntityId(param.getEntityId());
            for (Map.Entry entry : centUsedMap.entrySet()) {
                Cents cent = (Cents)entry.getKey();
                Cents updateCent = new Cents();
                updateCent.setId(cent.getId());
                updateCent.setBalance(cent.getBalance() - (Integer)entry.getValue());
                if (updateCent.getBalance() == 0) {
                    updateCent.setStatus(Cents.Status.USED);
                }
                CentConsumeDetail detail = new CentConsumeDetail();
                detail.setCent(updateCent);
                detail.setCentAmt((Integer)entry.getValue());
                detail.setRecord(consumeRecord);
                consumeDetailList.add(detail);
                ((CentsDao)this.entityDao).update(updateCent);
            }
            consumeRecord.setCentDetails(consumeDetailList);
            this.consumeRecordService.save(consumeRecord);
            msg = "\u6210\u529f\u6263\u51cf\u79ef\u5206\uff1a" + param.getCent();
            this.log.info("\u7528\u6237[" + param.getUserId() + "]" + msg);
        }
        finally {
            rLock.unlock();
        }
        return StatusDto.buildSuccessStatusDto(msg);
    }
}

