/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.service.impl.coupons;

import com.google.common.collect.Maps;
import com.rocoinfo.rocomall.common.service.CrudService;
import com.rocoinfo.rocomall.common.service.ServiceException;
import com.rocoinfo.rocomall.dto.CouponsInfoDto;
import com.rocoinfo.rocomall.dto.StatusDto;
import com.rocoinfo.rocomall.entity.account.User;
import com.rocoinfo.rocomall.entity.coupons.CouponsInfo;
import com.rocoinfo.rocomall.entity.coupons.CouponsProvideInfo;
import com.rocoinfo.rocomall.repository.account.UserDao;
import com.rocoinfo.rocomall.repository.coupons.CouponsInfoDao;
import com.rocoinfo.rocomall.repository.coupons.CouponsProvideInfoDao;
import com.rocoinfo.rocomall.service.coupons.ICouponsInfoService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.aop.framework.AopContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class CouponsInfoService
extends CrudService<CouponsInfoDao, CouponsInfo>
implements ICouponsInfoService {
    @Autowired
    private UserDao userDao;
    @Autowired
    private CouponsProvideInfoDao couponsProvideInfoDao;

    @Override
    public boolean isHasCode(String code) {
        if (code == null) {
            throw new ServiceException("\u4f18\u60e0\u5377\u7f16\u53f7\u4e3a\u7a7a\uff01");
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("code", code);
        return ((CouponsInfoDao)this.entityDao).searchTotal(params) > 0L;
    }

    @Override
    public void updateStatus(Long id) {
        ((CouponsInfoDao)this.entityDao).updateStatus(id);
    }

    @Override
    public Object batchProvide(List<CouponsInfoDto> cardList) {
        if (CollectionUtils.isEmpty(cardList)) {
            return StatusDto.buildSuccessStatusDto("excel\u4e2d\u6ca1\u6709\u6570\u636e,\u65e0\u9700\u5bfc\u5165");
        }
        int lineNumber = 1;
        String temp = "\u7b2c%s\u884c%s\u5217";
        LinkedHashMap errorMsg = Maps.newLinkedHashMap();
        HashSet<String> codeSet = new HashSet<String>();
        HashSet<String> userNameSet = new HashSet<String>();
        for (CouponsInfoDto info : cardList) {
            ++lineNumber;
            if (info.getCode() == null) {
                errorMsg.put(String.format(temp, lineNumber, 1), "\u4f18\u60e0\u5377\u7f16\u7801\u4e3a\u7a7a\uff01");
            }
            if (info.getUserName() == null) {
                errorMsg.put(String.format(temp, lineNumber, 2), "\u7528\u6237\u540d\u4e3a\u7a7a\uff01");
            }
            codeSet.add(info.getCode());
            userNameSet.add(info.getUserName());
        }
        if (errorMsg.size() != 0) {
            return StatusDto.buildDataFailureStatusDto(this.printErrMsg(errorMsg));
        }
        ArrayList<String> codeList = new ArrayList<String>();
        ArrayList<String> userNameList = new ArrayList<String>();
        codeList.addAll(codeSet);
        userNameList.addAll(userNameSet);
        List<CouponsInfo> resultCodeList = ((CouponsInfoDao)this.entityDao).findCouponsByCode(codeList);
        List<User> resultUserNameList = this.userDao.findUserByUserNames(userNameList);
        HashMap<String, CouponsInfo> codeMap = new HashMap<String, CouponsInfo>();
        HashMap<String, User> userMap = new HashMap<String, User>();
        for (CouponsInfo couponsInfo : resultCodeList) {
            codeMap.put(couponsInfo.getCode(), couponsInfo);
        }
        for (User user : resultUserNameList) {
            userMap.put(user.getUsername(), user);
        }
        if (resultCodeList.size() != codeList.size() || resultUserNameList.size() != userNameList.size()) {
            lineNumber = 0;
            for (CouponsInfoDto couponsInfoDto : cardList) {
                ++lineNumber;
                if (codeMap.get(couponsInfoDto.getCode()) == null) {
                    errorMsg.put(String.format(temp, lineNumber, 1), "\u4e0d\u5b58\u5728\u6b64\u4f18\u60e0\u5377\uff01");
                }
                if (userMap.get(couponsInfoDto.getUserName()) != null) continue;
                errorMsg.put(String.format(temp, lineNumber, 2), "\u4e0d\u5b58\u5728\u6b64\u7528\u6237\uff01");
            }
            return StatusDto.buildDataFailureStatusDto(this.printErrMsg(errorMsg));
        }
        ArrayList<CouponsProvideInfo> infoList = new ArrayList<CouponsProvideInfo>();
        for (CouponsInfoDto info : cardList) {
            CouponsProvideInfo cpi = new CouponsProvideInfo();
            CouponsInfo ci = new CouponsInfo();
            ci.setId(((CouponsInfo)codeMap.get(info.getCode())).getId());
            cpi.setCoupons(ci);
            User user = new User();
            user.setId(((User)userMap.get(info.getUserName())).getId());
            cpi.setUser(user);
            cpi.setCreateTime(new Date());
            cpi.setUsed(false);
            cpi.setStatus(CouponsProvideInfo.Status.EFFECTIVE);
            infoList.add(cpi);
        }
        this.getProxy().batchInsert(infoList);
        return StatusDto.buildDataSuccessStatusDto("\u6279\u91cf\u53d1\u653e\u6210\u529f\uff01");
    }

    private String printErrMsg(Map<String, String> errmsg) {
        StringBuilder error = new StringBuilder(100);
        for (String k : errmsg.keySet()) {
            error.append(k).append(":").append(errmsg.get(k)).append(";");
        }
        return error.toString();
    }

    private CouponsInfoService getProxy() {
        return (CouponsInfoService)AopContext.currentProxy();
    }

    @Override
    @Transactional(isolation=Isolation.READ_COMMITTED, propagation=Propagation.REQUIRED)
    public void batchInsert(List<CouponsProvideInfo> infoList) {
        if (infoList != null && infoList.size() > 0) {
            ((CouponsInfoDao)this.entityDao).batchInsert(infoList);
        }
    }
}

