/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.service.impl.dict;

import com.google.common.collect.Lists;
import com.rocoinfo.rocomall.common.service.CrudService;
import com.rocoinfo.rocomall.entity.dict.DictAdvType;
import com.rocoinfo.rocomall.enumconst.Status;
import com.rocoinfo.rocomall.repository.dict.DictAdvTypeDao;
import com.rocoinfo.rocomall.service.dict.IDictAdvTypeService;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.aop.framework.AopContext;
import org.springframework.cache.Cache;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class DictAdvTypeService
extends CrudService<DictAdvTypeDao, DictAdvType>
implements IDictAdvTypeService {
    @Override
    @Cacheable(value={"cache"}, key="'cache.bannertype.all'")
    public List<DictAdvType> findAll() {
        return super.findAll();
    }

    @Override
    public boolean isExistCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return false;
        }
        for (DictAdvType advType : this.getProxy().findAll()) {
            if (advType == null || !advType.getCode().equalsIgnoreCase(code)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isExistName(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return false;
        }
        for (DictAdvType advType : this.getProxy().findAll()) {
            if (advType == null || !advType.getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void switchStatus(Long id, Status status) {
        DictAdvType advType = new DictAdvType();
        advType.setId(id);
        advType.setStatus(status);
        this.update(advType);
    }

    @Override
    public List<DictAdvType> findByStatus(Status status) {
        List<DictAdvType> all = this.getProxy().findAll();
        if (status == null) {
            return all;
        }
        ArrayList filterAdvTypes = Lists.newArrayList();
        for (DictAdvType advType : all) {
            if (advType.getStatus() != status) continue;
            filterAdvTypes.add(advType);
        }
        return filterAdvTypes;
    }

    @Override
    protected void evictCacheEntitysHook() {
        String key = StringUtils.substringBetween((String)"'cache.bannertype.all'", (String)"'");
        Cache cache = this.cacheManager.getCache("cache");
        cache.evict((Object)key);
    }

    public DictAdvTypeService getProxy() {
        return (DictAdvTypeService)AopContext.currentProxy();
    }
}

