/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.service.impl.dict.express;

import com.rocoinfo.rocomall.common.service.CrudService;
import com.rocoinfo.rocomall.common.service.ServiceException;
import com.rocoinfo.rocomall.entity.dict.express.ExpressFeeItem;
import com.rocoinfo.rocomall.entity.dict.express.ExpressFeeTemplate;
import com.rocoinfo.rocomall.entity.dict.express.QuantityAmt;
import com.rocoinfo.rocomall.repository.dict.express.ExpressFeeTemplateDao;
import com.rocoinfo.rocomall.service.dict.express.IExpressFeeItemService;
import com.rocoinfo.rocomall.service.dict.express.IExpressFeeTemplateService;
import com.rocoinfo.rocomall.utils.ArithUtils;
import java.util.Date;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class ExpressFeeTemplateService
extends CrudService<ExpressFeeTemplateDao, ExpressFeeTemplate>
implements IExpressFeeTemplateService {
    @Autowired
    private IExpressFeeItemService feeItemService;

    @Override
    @Transactional(isolation=Isolation.READ_COMMITTED)
    public void insert(ExpressFeeTemplate feeTemplate) {
        if (feeTemplate != null) {
            super.insert(feeTemplate);
            this.saveTempateItems(feeTemplate);
        }
    }

    @Override
    @Transactional(isolation=Isolation.READ_COMMITTED)
    public void update(ExpressFeeTemplate feeTemplate) {
        if (feeTemplate != null) {
            super.update(feeTemplate);
            this.feeItemService.deleteFeeItemsByTemplateId(feeTemplate.getId());
            this.saveTempateItems(feeTemplate);
        }
    }

    private void saveTempateItems(ExpressFeeTemplate feeTemplate) {
        if (CollectionUtils.isNotEmpty(feeTemplate.getItems())) {
            for (ExpressFeeItem item : feeTemplate.getItems()) {
                item.setFeeTemplate(feeTemplate);
                this.feeItemService.insert(item);
            }
        }
    }

    @Override
    public ExpressFeeTemplate getTemplateDetailById(Long id) {
        if (id == null) {
            throw new ServiceException("\u6a21\u677fID\u4e3a\u7a7a\uff01");
        }
        return ((ExpressFeeTemplateDao)this.entityDao).getTemplateDetailById(id);
    }

    @Override
    public double calculateDeliverFee(Long cityId, Long expressId, int orderWeight) {
        QuantityAmt qAmt = null;
        ExpressFeeItem feeItem = this.feeItemService.getFeeItemByCityIdAndExpressId(cityId, expressId);
        if (feeItem != null) {
            qAmt = feeItem.getQamt();
        } else {
            ExpressFeeTemplate feeTemplate = ((ExpressFeeTemplateDao)this.entityDao).getByExpressId(expressId);
            if (feeTemplate != null) {
                qAmt = feeTemplate.getDef();
            }
        }
        if (qAmt == null) {
            return 0.0;
        }
        if (orderWeight <= qAmt.getInitQuantity()) {
            return qAmt.getInitAmt();
        }
        int orderOverWeight = orderWeight - qAmt.getInitQuantity();
        double overFee = (double)orderOverWeight * qAmt.getIncrAmt() / (double)qAmt.getIncrUnit().intValue();
        double totalFee = ArithUtils.round(overFee + qAmt.getInitAmt(), 2);
        return totalFee;
    }

    @Override
    public long countTemplateByExpress(ExpressFeeTemplate expressTemplate) {
        long count = 0L;
        if (expressTemplate != null && expressTemplate.getExpress() != null && expressTemplate.getExpress().getId() > 0L) {
            count = ((ExpressFeeTemplateDao)this.entityDao).countTemplateByExpress(expressTemplate);
        }
        return count;
    }

    @Override
    public ExpressFeeTemplate cloneTemplate(Long id) {
        if (id == null) {
            throw new ServiceException("\u539f\u59cb\u6a21\u677fID\u4e3a\u7a7a\uff01");
        }
        ExpressFeeTemplate template = this.getTemplateDetailById(id);
        if (template == null) {
            throw new ServiceException("\u6ca1\u6709\u6b64\u6a21\u677f\uff01");
        }
        template.setName(this.creatColneName(template.getName()));
        template.setId(null);
        template.setExpress(null);
        this.insert(template);
        return template;
    }

    private String creatColneName(String oldName) {
        int index = oldName.lastIndexOf("\u590d\u5236(");
        String newName = "";
        newName = index != -1 ? oldName.substring(0, index) + "\u590d\u5236(" + new Date().getTime() + ")" : oldName + "\u590d\u5236(" + new Date().getTime() + ")";
        return newName;
    }
}

