/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.service.impl.insurance;

import com.rocoinfo.rocomall.common.service.CrudService;
import com.rocoinfo.rocomall.entity.insurance.InsuredInfo;
import com.rocoinfo.rocomall.repository.insurance.InsuredInfoDao;
import com.rocoinfo.rocomall.service.insurance.IInsuredInfoService;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Transactional
public class InsuredInfoService
extends CrudService<InsuredInfoDao, InsuredInfo>
implements IInsuredInfoService {
    @Override
    public InsuredInfo getByMobileOrOpenid(String username) {
        List<InsuredInfo> list = ((InsuredInfoDao)this.entityDao).findByUsername(username);
        if (list != null && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public List<InsuredInfo> findByRelationId(Long id) {
        return ((InsuredInfoDao)this.entityDao).findByRelationId(id);
    }

    @Override
    public void createUserInfo(Long id, String username) {
        if (StringUtils.isBlank((CharSequence)username)) {
            return;
        }
        InsuredInfo hasUser = this.getByMobileOrOpenid(username);
        if (hasUser == null) {
            ((InsuredInfoDao)this.entityDao).createUserInfo(id, username);
        }
    }

    @Override
    public void createUserRelationship(InsuredInfo loginUser, InsuredInfo relationUser, boolean isLogin) {
        InsuredInfo hasRegistUser;
        if (loginUser == null || relationUser == null) {
            return;
        }
        Long loginUserId = loginUser.getId();
        Long relationId = relationUser.getId();
        if (!isLogin && (hasRegistUser = this.getByMobileOrOpenid(loginUser.getMobile())) != null) {
            loginUserId = hasRegistUser.getId();
        }
        if (!this.hasRelation(loginUserId, relationId)) {
            ((InsuredInfoDao)this.entityDao).createUserRelationship(loginUserId, relationId);
        }
    }

    @Override
    public void saveOrUpdate(InsuredInfo insuredInfo) {
        if (insuredInfo == null) {
            return;
        }
        InsuredInfo exsistUser = this.getByCardNo(insuredInfo.getCardNo());
        if (exsistUser != null) {
            insuredInfo.setId(exsistUser.getId());
            this.update(insuredInfo);
        } else {
            this.insert(insuredInfo);
        }
    }

    @Override
    public InsuredInfo getByCardNo(String cardNo) {
        List<InsuredInfo> list;
        if (StringUtils.isNotBlank((CharSequence)cardNo) && (list = ((InsuredInfoDao)this.entityDao).findByCardNo(cardNo)) != null && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public boolean hasRelation(Long insuredId, Long relationId) {
        Long count = ((InsuredInfoDao)this.entityDao).getRelationCount(insuredId, relationId);
        return count > 0L;
    }

    @Override
    public void createNewAccount(InsuredInfo insuredInfo, String username) {
        InsuredInfo exsistAccount = this.getByMobileOrOpenid(username);
        if (exsistAccount == null) {
            this.insert(insuredInfo);
            this.createUserInfo(insuredInfo.getId(), username);
        }
    }
}

