/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.service.impl.order;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.rocoinfo.rocomall.common.service.CrudService;
import com.rocoinfo.rocomall.entity.Sku;
import com.rocoinfo.rocomall.entity.dict.DictWarehouse;
import com.rocoinfo.rocomall.entity.dict.express.DictExpress;
import com.rocoinfo.rocomall.entity.order.DistributionOrder;
import com.rocoinfo.rocomall.entity.order.MergeDistributeOrder;
import com.rocoinfo.rocomall.entity.order.Order;
import com.rocoinfo.rocomall.entity.order.OrderItem;
import com.rocoinfo.rocomall.entity.order.OrderOutStore;
import com.rocoinfo.rocomall.repository.order.DistributionOrderDao;
import com.rocoinfo.rocomall.service.impl.order.OrderOutStoreService;
import com.rocoinfo.rocomall.service.impl.order.OrderService;
import com.rocoinfo.rocomall.service.order.IDistributionOrderService;
import com.rocoinfo.rocomall.utils.CodeGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;
import org.springside.modules.utils.Collections3;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class DistributionOrderService
extends CrudService<DistributionOrderDao, DistributionOrder>
implements IDistributionOrderService {
    @Autowired
    private CodeGenerator codeGenerator;
    @Autowired
    private OrderService orderService;
    @Autowired
    private OrderOutStoreService outstoreService;

    @Override
    public List<DistributionOrder> findDistributeOrderWithItemAddrByIdIn(List<Long> distriOrderIdList) {
        if (CollectionUtils.isEmpty(distriOrderIdList)) {
            return Collections.emptyList();
        }
        return ((DistributionOrderDao)this.entityDao).findDistributeOrderWithItemAddrByIdIn(distriOrderIdList);
    }

    @Override
    public List<Long> findDistributeOrderIdsByMergeCode(String mergeCode) {
        if (StringUtils.isEmpty((CharSequence)mergeCode)) {
            return Collections.emptyList();
        }
        return ((DistributionOrderDao)this.entityDao).findDistributeOrderIdsByMergeCode(mergeCode);
    }

    @Override
    @Transactional(isolation=Isolation.READ_COMMITTED)
    public void generateDistributeOrder(Order order) {
        ArrayList materialItems = Lists.newArrayList();
        for (OrderItem item : order.getItems()) {
            if (!OrderItem.Group.MATERIAL.equals((Object)item.getGroup())) continue;
            materialItems.add(item);
        }
        if (CollectionUtils.isNotEmpty((Collection)materialItems)) {
            ArrayList distriOrderList = Lists.newArrayListWithExpectedSize((int)materialItems.size());
            ArrayListMultimap orderGroupList = ArrayListMultimap.create();
            Date createTime = new Date();
            for (OrderItem itm : materialItems) {
                DistributionOrder distriOrder = new DistributionOrder();
                distriOrder.setCode(this.codeGenerator.generateDistributionOrderCode(itm.getOrderCode()));
                distriOrder.setExported(Boolean.FALSE);
                distriOrder.setOrderItem(itm);
                distriOrder.setMergeCode("");
                distriOrder.setExpress(itm.getExpress());
                distriOrder.setCreateTime(createTime);
                distriOrderList.add(distriOrder);
                if (itm.getExpress() == null || itm.getExpress().getId() <= 0L) continue;
                String wareHouseExpr = itm.getWareHouse().getId() + "-" + itm.getExpress().getId();
                orderGroupList.put((Object)wareHouseExpr, (Object)distriOrder);
            }
            for (Collection group : orderGroupList.asMap().values()) {
                if (group.size() < 2) continue;
                String mergeCode = null;
                for (DistributionOrder grpItem : group) {
                    if (mergeCode == null) {
                        mergeCode = grpItem.getCode();
                    }
                    grpItem.setMergeCode(mergeCode);
                }
            }
            ((DistributionOrderDao)this.entityDao).batchSave(distriOrderList);
            Order orderToDistr = new Order();
            orderToDistr.setDistributed(Boolean.TRUE);
            orderToDistr.setId(order.getId());
            this.orderService.update(orderToDistr);
        }
    }

    @Override
    @Transactional(isolation=Isolation.READ_COMMITTED)
    public void generateOutstoreOrder(List<DistributionOrder> distriOrderList, Long operatorId) {
        if (CollectionUtils.isNotEmpty(distriOrderList)) {
            String keyTemplate = "%d-%d-%s";
            ArrayListMultimap multiMap = ArrayListMultimap.create();
            for (DistributionOrder distriOrder : distriOrderList) {
                DictWarehouse wareHouse = distriOrder.getOrderItem().getWareHouse();
                DictExpress express = distriOrder.getExpress();
                String skuCode = distriOrder.getOrderItem().getSku().getCode();
                String key = String.format(keyTemplate, wareHouse.getId(), express.getId(), skuCode);
                multiMap.put((Object)key, (Object)distriOrder);
            }
            ArrayList distriOrderIds = Lists.newArrayList();
            ArrayList outStoreIds = Lists.newArrayList();
            Iterator iter = multiMap.keySet().iterator();
            while (iter.hasNext()) {
                List ordList = multiMap.get(iter.next());
                OrderOutStore outstoreOrder = null;
                int quantityTotal = 0;
                Date createTime = new Date();
                for (DistributionOrder ord : ordList) {
                    if (outstoreOrder == null) {
                        outstoreOrder = new OrderOutStore();
                        outstoreOrder.setCode(this.codeGenerator.generateOutstoreOrderCode());
                        outstoreOrder.setCreateTime(createTime);
                        outstoreOrder.setExpress(ord.getExpress());
                        outstoreOrder.setState(Boolean.FALSE);
                        Sku sku = ord.getOrderItem().getSku();
                        if (StringUtils.isEmpty((CharSequence)sku.getName())) {
                            sku.setName(ord.getOrderItem().getProductName());
                        }
                        outstoreOrder.setSku(sku);
                        outstoreOrder.setWarehouse(ord.getOrderItem().getWareHouse());
                    }
                    distriOrderIds.add(ord.getId());
                    quantityTotal += ord.getOrderItem().getQuantity().intValue();
                }
                outstoreOrder.setQuantity(quantityTotal);
                this.outstoreService.insert(outstoreOrder);
                for (int i = 0; i < ordList.size(); ++i) {
                    outStoreIds.add(outstoreOrder.getId());
                }
            }
            ((DistributionOrderDao)this.entityDao).updateExportedAndOutstoreIds(distriOrderIds, outStoreIds, operatorId);
            for (Long id : outStoreIds) {
                this.outstoreService.upDateOrderItemStatus(OrderItem.Status.PAID, OrderItem.AdmStatus.DISTRIBUTION_WAIT_OUT, id);
            }
        }
    }

    @Override
    public void mergeOrSplit(List<Long> distriOrderIdList, String mergeCode) {
        if (CollectionUtils.isNotEmpty(distriOrderIdList)) {
            ((DistributionOrderDao)this.entityDao).mergeOrSplit(distriOrderIdList, mergeCode);
        }
        if (mergeCode != null && !mergeCode.trim().equals("")) {
            ((DistributionOrderDao)this.entityDao).updateOrderItemByIds(distriOrderIdList, OrderItem.Status.PAID, OrderItem.AdmStatus.DISTRIBUTION_MERGED);
        }
    }

    @Override
    @Transactional(isolation=Isolation.READ_COMMITTED)
    public void importLogistics(List<DistributionOrder> distriOrderList) {
        if (CollectionUtils.isNotEmpty(distriOrderList)) {
            for (DistributionOrder distrOrder : distriOrderList) {
                ((DistributionOrderDao)this.entityDao).update(distrOrder);
            }
            List distriOrderCodeList = Collections3.extractToList(distriOrderList, (String)"code");
            ((DistributionOrderDao)this.entityDao).updateOrderItemToDelivered(distriOrderCodeList, OrderItem.Status.RECEIVING, OrderItem.AdmStatus.DELIVERED, false);
        }
    }

    @Override
    @Transactional(isolation=Isolation.READ_COMMITTED)
    public void updateOrderItemStatus(List<DistributionOrder> distriOrderList, OrderItem.Status status, OrderItem.AdmStatus admStatus) {
        if (CollectionUtils.isNotEmpty(distriOrderList)) {
            List distriOrderCodeList = Collections3.extractToList(distriOrderList, (String)"code");
            ((DistributionOrderDao)this.entityDao).updateOrderItemToDelivered(distriOrderCodeList, status, admStatus, true);
        }
    }

    @Override
    public Page<MergeDistributeOrder> searchMergeDistributeOrder(Map<String, Object> params, Pageable pageable) {
        params.put("offset", pageable.getPageNumber());
        params.put("pageSize", pageable.getPageSize());
        params.put("sort", pageable.getSort());
        List<Object> pageData = Collections.emptyList();
        Long count = ((DistributionOrderDao)this.entityDao).searchTotalMergeDistriOrder(params);
        if (count > 0L) {
            pageData = ((DistributionOrderDao)this.entityDao).searchMergeDistriOrder(params);
        }
        return new PageImpl(pageData, pageable, count.longValue());
    }
}

