/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.service.impl.order;

import com.google.common.collect.Maps;
import com.rocoinfo.rocomall.common.service.CrudService;
import com.rocoinfo.rocomall.entity.order.InstoreOrder;
import com.rocoinfo.rocomall.entity.order.OrderItem;
import com.rocoinfo.rocomall.entity.workorder.WorkOrderRefundDetail;
import com.rocoinfo.rocomall.repository.order.InstoreOrderDao;
import com.rocoinfo.rocomall.service.order.IInstoreOrderService;
import com.rocoinfo.rocomall.service.order.IOrderItemService;
import com.rocoinfo.rocomall.service.product.ISkuService;
import com.rocoinfo.rocomall.service.workorder.IWorkOrderRefundDetailService;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class InstoreOrderService
extends CrudService<InstoreOrderDao, InstoreOrder>
implements IInstoreOrderService {
    @Autowired
    private IOrderItemService orderItemService;
    @Autowired
    private IWorkOrderRefundDetailService refundDetailService;
    @Autowired
    private ISkuService skuService;

    @Override
    @Transactional
    public void insert(InstoreOrder instoreOrder) {
        if (instoreOrder != null) {
            super.insert(instoreOrder);
            if (InstoreOrder.ReceiveStatus.FINISHED.equals((Object)instoreOrder.getReceiveState())) {
                this.skuService.incrOrDecrStock(instoreOrder.getSku().getId(), instoreOrder.getQuantity(), instoreOrder.getWarehouse().getId());
            }
        }
    }

    @Override
    public Page<InstoreOrder> searchInstoreRecordsByProdId(Long productId, Pageable pageable) {
        List<Object> pageData = Collections.emptyList();
        Long count = 0L;
        if (productId != null && productId > 0L) {
            HashMap params = Maps.newHashMap();
            params.put("productId", productId);
            params.put("offset", pageable.getPageNumber());
            params.put("pageSize", pageable.getPageSize());
            params.put("sort", pageable.getSort());
            count = ((InstoreOrderDao)this.entityDao).searchTotalInstoreRecordsByProdId(params);
            if (count > 0L) {
                pageData = ((InstoreOrderDao)this.entityDao).searchInstoreRecordsByProdId(params);
            }
        }
        return new PageImpl(pageData, pageable, count.longValue());
    }

    @Override
    @Transactional
    public void refundConfirmReceive(InstoreOrder instoreOrder) {
        if (InstoreOrder.ReceiveStatus.UNFINISHED.equals((Object)instoreOrder.getReceiveState())) {
            InstoreOrder inStoreUpdate = new InstoreOrder();
            inStoreUpdate.setId(instoreOrder.getId());
            inStoreUpdate.setReceiveState(InstoreOrder.ReceiveStatus.FINISHED);
            inStoreUpdate.setReceiveDateTime(new Date());
            ((InstoreOrderDao)this.entityDao).update(inStoreUpdate);
            WorkOrderRefundDetail refundDetailItem = new WorkOrderRefundDetail();
            refundDetailItem.setRefunded(Boolean.TRUE);
            refundDetailItem.setId(instoreOrder.getRefundDetailId());
            this.refundDetailService.update(refundDetailItem);
            this.skuService.incrOrDecrStock(instoreOrder.getSku().getId(), instoreOrder.getQuantity(), null);
            OrderItem updateItem = new OrderItem();
            updateItem.setAdmStatus(OrderItem.AdmStatus.REFUND_RECEIVED);
            updateItem.setStatus(OrderItem.Status.REFUNDING);
            updateItem.setOrderCode(instoreOrder.getOrderCode());
            this.orderItemService.update(updateItem);
        }
    }
}

