/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.service.impl.order;

import com.rocoinfo.rocomall.common.service.CrudService;
import com.rocoinfo.rocomall.entity.account.User;
import com.rocoinfo.rocomall.entity.insurance.InsuredInfo;
import com.rocoinfo.rocomall.entity.order.Order;
import com.rocoinfo.rocomall.entity.order.OrderInsurance;
import com.rocoinfo.rocomall.entity.order.OrderItem;
import com.rocoinfo.rocomall.repository.order.OrderInsuranceDao;
import com.rocoinfo.rocomall.service.insurance.IInsuredInfoService;
import com.rocoinfo.rocomall.service.order.IOrderInsuranceService;
import com.rocoinfo.rocomall.service.order.IOrderService;
import com.rocoinfo.rocomall.utils.CodeGenerator;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class OrderInsuranceService
extends CrudService<OrderInsuranceDao, OrderInsurance>
implements IOrderInsuranceService {
    @Autowired
    private IOrderService orderService;
    @Autowired
    private IInsuredInfoService iInsuredInfoService;
    @Autowired
    private CodeGenerator codeGenerator;

    @Override
    public OrderInsurance getByOrderCode(String orderCode) {
        OrderInsurance orderInsurance = null;
        if (StringUtils.isNotBlank((CharSequence)orderCode)) {
            orderInsurance = ((OrderInsuranceDao)this.entityDao).getByOrderCode(orderCode);
        }
        return orderInsurance;
    }

    @Override
    @Transactional
    public void insert(OrderInsurance orderInsurance) {
        Order order = new Order();
        order.setCreateTime(new Date());
        order.setOrderCode(this.codeGenerator.generateOrderCode(new Date(), OrderItem.OrderType.common));
        User user = new User();
        user.setId(0L);
        order.setUser(user);
        order.setDistributed(false);
        order.setLocked(false);
        order.setCashAmt(0.0);
        order.setCashPayed(false);
        order.setCent(0);
        order.setCentPayed(false);
        this.orderService.insert(order);
        orderInsurance.setOrderCode(order.getOrderCode());
        orderInsurance.setCreateDate(new Date());
        super.insert(orderInsurance);
    }

    @Override
    @Transactional
    public void insertOrder(OrderInsurance orderInsurance, InsuredInfo loginUser) {
        Order order = new Order();
        order.setCreateTime(new Date());
        order.setOrderCode(this.codeGenerator.generateOrderCode(new Date(), OrderItem.OrderType.common));
        User user = new User();
        user.setId(0L);
        order.setUser(user);
        order.setDistributed(false);
        order.setLocked(false);
        order.setCashAmt(0.0);
        order.setCashPayed(false);
        order.setCent(0);
        order.setCentPayed(false);
        this.orderService.insert(order);
        orderInsurance.setOrderCode(order.getOrderCode());
        orderInsurance.setCreateDate(new Date());
        super.insert(orderInsurance);
        this.iInsuredInfoService.saveOrUpdate(orderInsurance.getApplicant());
        this.iInsuredInfoService.saveOrUpdate(orderInsurance.getInsuredInfo());
        if (loginUser != null) {
            this.iInsuredInfoService.createUserRelationship(loginUser, orderInsurance.getApplicant(), true);
            this.iInsuredInfoService.createUserRelationship(loginUser, orderInsurance.getInsuredInfo(), true);
        } else {
            this.iInsuredInfoService.createUserRelationship(orderInsurance.getInsuredInfo(), orderInsurance.getApplicant(), false);
            this.iInsuredInfoService.createUserRelationship(orderInsurance.getInsuredInfo(), orderInsurance.getInsuredInfo(), false);
        }
        this.iInsuredInfoService.createUserInfo(orderInsurance.getInsuredInfo().getId(), orderInsurance.getInsuredInfo().getMobile());
    }

    @Override
    public List<OrderInsurance> getByMobile(String mobile) {
        List<OrderInsurance> result = null;
        if (StringUtils.isNotBlank((CharSequence)mobile)) {
            result = ((OrderInsuranceDao)this.entityDao).getByMobile(mobile);
        }
        return result;
    }
}

