/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.service.impl.order;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.rocoinfo.rocomall.common.service.CrudService;
import com.rocoinfo.rocomall.common.service.ServiceException;
import com.rocoinfo.rocomall.dto.RefundParam;
import com.rocoinfo.rocomall.dto.StatusDto;
import com.rocoinfo.rocomall.dto.admin.OrderBitchSendImportExcelDto;
import com.rocoinfo.rocomall.dto.admin.OrderBitchSendImportExcelFailDto;
import com.rocoinfo.rocomall.dto.admin.OrderItemExchageRefundParamDto;
import com.rocoinfo.rocomall.entity.CardDeliverRecord;
import com.rocoinfo.rocomall.entity.OrderItemOperationLog;
import com.rocoinfo.rocomall.entity.ProdReturnRecord;
import com.rocoinfo.rocomall.entity.Product;
import com.rocoinfo.rocomall.entity.Sku;
import com.rocoinfo.rocomall.entity.Supplier;
import com.rocoinfo.rocomall.entity.VirtualProduct;
import com.rocoinfo.rocomall.entity.account.AdminUser;
import com.rocoinfo.rocomall.entity.account.User;
import com.rocoinfo.rocomall.entity.dict.express.DictExpress;
import com.rocoinfo.rocomall.entity.order.Order;
import com.rocoinfo.rocomall.entity.order.OrderItem;
import com.rocoinfo.rocomall.enumconst.Status;
import com.rocoinfo.rocomall.redis.JedisTemplate;
import com.rocoinfo.rocomall.repository.OrderItemOperationLogDao;
import com.rocoinfo.rocomall.repository.ProdReturnRecordDao;
import com.rocoinfo.rocomall.repository.order.OrderItemDao;
import com.rocoinfo.rocomall.service.IAddressService;
import com.rocoinfo.rocomall.service.IUserService;
import com.rocoinfo.rocomall.service.cent.ICentsService;
import com.rocoinfo.rocomall.service.dict.express.IDictExpressService;
import com.rocoinfo.rocomall.service.impl.ICardDeliverRecordService;
import com.rocoinfo.rocomall.service.order.IOrderItemService;
import com.rocoinfo.rocomall.service.order.IOrderService;
import com.rocoinfo.rocomall.service.product.IProductService;
import com.rocoinfo.rocomall.service.product.ISkuService;
import com.rocoinfo.rocomall.service.product.ISupplierService;
import com.rocoinfo.rocomall.service.product.IVirtualProductService;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springside.modules.utils.Collections3;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Transactional
public class OrderItemService
extends CrudService<OrderItemDao, OrderItem>
implements IOrderItemService {
    @Autowired
    private OrderItemOperationLogDao operLogDao;
    @Autowired
    private ProdReturnRecordDao prodReturnRecordDao;
    @Autowired
    private ISkuService skuService;
    @Autowired
    private IOrderService orderService;
    @Autowired
    private JedisTemplate jedisTemplate;
    @Autowired
    private IAddressService addressService;
    @Autowired
    private IDictExpressService expressService;
    @Autowired
    private IProductService productService;
    @Autowired
    private ISupplierService supplierService;
    @Autowired
    private IUserService userService;
    @Autowired
    private ICardDeliverRecordService cardDeliverRecordService;
    @Autowired
    private IVirtualProductService virtualProductService;
    @Autowired
    private ICentsService centsService;

    @Override
    @Cacheable(value={"cache"}, key="'cache.sale_order_items_in_order.'+#orderId")
    public List<OrderItem> findByOrderId(Long orderId) {
        return ((OrderItemDao)this.entityDao).findByOrderId(orderId);
    }

    @Override
    public OrderItem getSaleItemWithExpressById(Long id) {
        return ((OrderItemDao)this.entityDao).getSaleItemWithExpressById(id);
    }

    @Override
    @CacheEvict(value={"cache"}, key="'cache.sale_order_item.'+#orderItemId")
    public void updateExpressAndTransportNoById(long expressId, String transportNo, long orderItemId) {
        if (expressId > 0L && StringUtils.isNotEmpty((CharSequence)transportNo) && orderItemId > 0L) {
            OrderItem orderItem = new OrderItem();
            orderItem.setId(orderItemId);
            orderItem.setExpress(new DictExpress(expressId));
            orderItem.setTransportNo(transportNo);
            this.update(orderItem);
        }
    }

    @Override
    public List<OrderItem> findWithSkuByOrderIdsIn(List<Long> orderIdList) {
        if (CollectionUtils.isNotEmpty(orderIdList)) {
            return ((OrderItemDao)this.entityDao).findWithSkuByOrderIdsIn(orderIdList);
        }
        return Collections.emptyList();
    }

    @Override
    public Page<OrderItem> adminSearch(Map<String, Object> params, Pageable pageable) {
        Long total = ((OrderItemDao)this.entityDao).adminSearchTotal(params);
        List<Object> orderitems = Collections.emptyList();
        if (total > (long)pageable.getOffset()) {
            params.put("offset", pageable.getOffset());
            params.put("pageSize", pageable.getPageSize());
            params.put("sort", pageable.getSort());
            orderitems = ((OrderItemDao)this.entityDao).adminSearch(params);
        }
        return new PageImpl(orderitems, pageable, total.longValue());
    }

    @Override
    public List<OrderItem> adminExportSearch(Map<String, Object> params) {
        return ((OrderItemDao)this.entityDao).adminExportSearch(params);
    }

    @Override
    public void cancelOrder(long orderId, Long loggedUserId, boolean isReleaseOccupedStock) {
        Order order = (Order)this.orderService.getById(orderId);
        OrderItem updateItem = new OrderItem();
        updateItem.setAdmStatus(OrderItem.AdmStatus.CANCELED);
        updateItem.setStatus(OrderItem.Status.CANCELED);
        updateItem.setOrder(order);
        this.update(updateItem);
        int refundCent = order.getCent();
        if (isReleaseOccupedStock) {
            this.orderService.releaseOrOccupyStockByOrderId(orderId, 1);
        }
    }

    @Override
    @Transactional(isolation=Isolation.READ_COMMITTED, propagation=Propagation.REQUIRED)
    @CacheEvict(value={"cache"}, key="'cache.sale_order_item.'+#orderItemId")
    public void cancelOrderItem(long orderItemId, Long loggedUserId) {
        OrderItem orderItem = (OrderItem)this.getById(orderItemId);
        if (orderItem != null && orderItem.getStatus() == OrderItem.Status.PAID) {
            OrderItem item = new OrderItem();
            item.setId(orderItemId);
            item.setStatus(OrderItem.Status.CANCELED);
            this.update(item);
            this.skuService.decreaseOccupiedStockAndSaleVolumeOnCancel(item.getSku().getId(), item.getQuantity());
            int refundCent = item.getCent() * item.getQuantity();
            RefundParam refundParam = new RefundParam();
            refundParam.setCent(refundCent);
            refundParam.setEntityId(item.getOrder().getId());
            refundParam.setConsumeTypeCode(item.getOrderType().getCode());
            refundParam.setUserId(item.getUser().getId());
            OrderItemOperationLog operLog = new OrderItemOperationLog();
            operLog.setOperator(new AdminUser(loggedUserId));
            operLog.setOperation(OrderItem.OrderAction.CANCEL.getName());
            operLog.setLogTime(new Date());
            operLog.setOrderItem(item);
            this.operLogDao.insert(operLog);
        }
    }

    @Override
    @Transactional(isolation=Isolation.READ_COMMITTED, propagation=Propagation.REQUIRED)
    public void sendOrder(OrderItem sendOrder, Long loggedUserId) {
        long orderItemId = sendOrder.getId();
        if (sendOrder != null && sendOrder.getStatus() == OrderItem.Status.DEALED) {
            sendOrder.setStatus(OrderItem.Status.SENDING);
            this.update(sendOrder);
            OrderItem detail = (OrderItem)((OrderItemDao)this.entityDao).getById(orderItemId);
            long skuId = detail.getSku().getId();
            int quantity = detail.getQuantity();
            this.skuService.decreaseStockAndOccupiedOnSend(skuId, quantity);
            OrderItemOperationLog operLog = new OrderItemOperationLog();
            operLog.setOperator(new AdminUser(loggedUserId));
            operLog.setOperation(OrderItem.OrderAction.MANUAL_SEND.getName());
            operLog.setLogTime(new Date());
            operLog.setOrderItem(sendOrder);
            this.operLogDao.insert(operLog);
        }
    }

    @Override
    @Transactional(isolation=Isolation.READ_COMMITTED, propagation=Propagation.REQUIRED)
    public void repeatSendOrder(long orderItemId) {
        if (orderItemId > 0L) {
            OrderItem orderItem = (OrderItem)super.getById(orderItemId);
            List<CardDeliverRecord> cardDeliverRecords = this.cardDeliverRecordService.getRecordByOrderItemIdNoStatus(orderItemId);
            Long userId = orderItem.getUser().getId();
            Sku sku = (Sku)this.skuService.getById(orderItem.getSku().getId());
            new Thread(new SendSMS(cardDeliverRecords, sku.getName(), userId)).start();
        }
    }

    @Override
    public void dealWithOrderItems(boolean isBatch, AdminUser operator, Long ... orderItemIds) {
        if (ArrayUtils.isNotEmpty((Object[])orderItemIds)) {
            ((OrderItemDao)this.entityDao).dealWithOrderItems(orderItemIds);
            this.batchClearCachedOrderItems(Arrays.asList(orderItemIds));
            OrderItemOperationLog operLog = new OrderItemOperationLog();
            operLog.setOperation(isBatch ? OrderItem.OrderAction.BATCH_DEAL.getName() : OrderItem.OrderAction.MANUAL_DEAL.getName());
            operLog.setLogTime(new Date());
            operLog.setOrderItem(new OrderItem(orderItemIds[0]));
            operLog.setOperator(operator);
            if (orderItemIds.length == 1) {
                this.operLogDao.insert(operLog);
            } else {
                ArrayList operLogList = Lists.newArrayListWithExpectedSize((int)orderItemIds.length);
                operLogList.add(operLog);
                for (int i = 1; i < orderItemIds.length; ++i) {
                    OrderItemOperationLog orderOperLog = new OrderItemOperationLog();
                    try {
                        BeanUtils.copyProperties((Object)orderOperLog, (Object)operLog);
                        orderOperLog.setOrderItem(new OrderItem(orderItemIds[i]));
                        operLogList.add(orderOperLog);
                        continue;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                this.operLogDao.batchInsert(operLogList);
            }
        }
    }

    private void batchClearSaleOrderItemCachesIdIn(List<Long> odrItemIdList) {
        String orderItemKeyPrefix = "'cache.sale_order_item.'+";
        orderItemKeyPrefix = StringUtils.substringBetween((String)orderItemKeyPrefix, (String)"'");
        ArrayList cacheKeyList = Lists.newArrayList();
        for (Long id : odrItemIdList) {
            cacheKeyList.add(orderItemKeyPrefix + id);
        }
        this.jedisTemplate.del(cacheKeyList.toArray(new String[0]));
    }

    @Override
    @CacheEvict(value={"cache"}, key="'cache.sale_order_item.'+#orderItemId")
    public void updateOrderState(long orderItemId, OrderItem.Status newStatus, OrderItem.AdmStatus admStatus, Long loggedUserId) {
        if (orderItemId > 0L && (newStatus == OrderItem.Status.FINISH || newStatus == OrderItem.Status.EXCHANGED || newStatus == OrderItem.Status.REFUNDED)) {
            OrderItem updateOrdItem = new OrderItem();
            updateOrdItem.setId(orderItemId);
            updateOrdItem.setStatus(newStatus);
            updateOrdItem.setAdmStatus(admStatus);
            this.update(updateOrdItem);
            OrderItemOperationLog operLog = new OrderItemOperationLog();
            operLog.setOperator(new AdminUser(loggedUserId));
            Date currDate = new Date();
            operLog.setLogTime(currDate);
            operLog.setOrderItem(new OrderItem(orderItemId));
            String operation = "";
            int status = 0;
            if (newStatus == OrderItem.Status.FINISH) {
                operation = OrderItem.OrderAction.RECEIVE.getName();
            } else if (newStatus == OrderItem.Status.EXCHANGED) {
                operation = OrderItem.OrderAction.COMPLETE_EXCHANGE.getName();
                status = 2;
            } else if (newStatus == OrderItem.Status.REFUNDED) {
                operation = OrderItem.OrderAction.COMPLETE_REFUND.getName();
                status = 4;
            }
            operLog.setOperation(operation);
            this.operLogDao.insert(operLog);
            if (status != 0) {
                ProdReturnRecord prodReturnRecord = new ProdReturnRecord();
                prodReturnRecord.setOrderItem(updateOrdItem);
                prodReturnRecord.setOrderFinishTime(currDate);
                prodReturnRecord.setStatus(status);
                this.prodReturnRecordDao.update(prodReturnRecord);
            }
        }
    }

    @Override
    public List<OrderItem> findDealedOrderItemsByCodesIn(List<String> orderCodes) {
        if (CollectionUtils.isNotEmpty(orderCodes)) {
            return ((OrderItemDao)this.entityDao).findDealedOrderItemsByCodesIn(orderCodes);
        }
        return Collections.emptyList();
    }

    @Override
    public void exchangeSalesOrderItems(OrderItemExchageRefundParamDto exchageParamDto) throws Exception {
        OrderItem orderItemForUpdate = (OrderItem)this.getById(exchageParamDto.getOrderItemId());
        if (null == orderItemForUpdate) {
            throw new Exception("\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        orderItemForUpdate.setStatus(OrderItem.Status.EXCHANGING);
        this.update(orderItemForUpdate);
        if (!exchageParamDto.getCanUse().booleanValue()) {
            this.skuService.decrStockAndIncrDefectStockOnExchange(orderItemForUpdate.getSku().getId(), exchageParamDto.getQuantity());
        }
        OrderItemOperationLog operLog = new OrderItemOperationLog();
        Date orderOpTime = new Date();
        operLog.setLogTime(orderOpTime);
        operLog.setOrderItem(orderItemForUpdate);
        operLog.setOperation(OrderItem.OrderAction.EXCHANGE.getName());
        String notePattern = "\u6362\u8d27\u8bf4\u660e\uff1a{0} <br/>  \u5546\u54c1\u662f\u5426\u53ef\u7528\uff1a{1} <br/>  \u6362\u8d27\u6570\u91cf:{2}";
        String note = MessageFormat.format(notePattern, exchageParamDto.getNote(), exchageParamDto.getCanUse() != false ? "\u662f" : "\u5426", exchageParamDto.getQuantity());
        operLog.setNote(note);
        this.operLogDao.insert(operLog);
        ProdReturnRecord prodReturnRecord = new ProdReturnRecord();
        prodReturnRecord.setCount(exchageParamDto.getQuantity());
        prodReturnRecord.setNote(exchageParamDto.getNote());
        prodReturnRecord.setOrderCreateTime(orderItemForUpdate.getCreateTime());
        prodReturnRecord.setOrderItem(orderItemForUpdate);
        prodReturnRecord.setOrderOpTime(orderOpTime);
        prodReturnRecord.setStatus(1);
        prodReturnRecord.setType(1);
        this.prodReturnRecordDao.insert(prodReturnRecord);
    }

    @Override
    public void doRefundSalesOrderItems(OrderItemExchageRefundParamDto refundParamDto) throws Exception {
        OrderItem orderItemForUpdate = (OrderItem)this.getById(refundParamDto.getOrderItemId());
        if (null == orderItemForUpdate) {
            throw new IllegalArgumentException("\u8ba2\u5355\u3010orderItemId:" + refundParamDto.getOrderItemId() + "\u3011\u4e0d\u5b58\u5728");
        }
        orderItemForUpdate.setStatus(OrderItem.Status.REFUNDING);
        this.update(orderItemForUpdate);
        if (refundParamDto.getCanUse().booleanValue()) {
            this.skuService.increaseStockOnRefundIfCanUse(orderItemForUpdate.getSku().getId(), refundParamDto.getQuantity());
        }
        int refundCent = orderItemForUpdate.getCent() * refundParamDto.getQuantity();
        RefundParam refundParam = new RefundParam();
        refundParam.setCent(refundCent);
        refundParam.setEntityId(orderItemForUpdate.getOrder().getId());
        refundParam.setConsumeTypeCode(orderItemForUpdate.getOrderType().getCode());
        refundParam.setUserId(orderItemForUpdate.getUser().getId());
        OrderItemOperationLog operLog = new OrderItemOperationLog();
        Date orderOpTime = new Date();
        operLog.setLogTime(orderOpTime);
        operLog.setOrderItem(orderItemForUpdate);
        operLog.setOperation(OrderItem.OrderAction.REFUND.getName());
        String notePattern = "\u9000\u8d27\u8bf4\u660e\uff1a{0} <br/>  \u5546\u54c1\u662f\u5426\u53ef\u7528\uff1a{1} <br/>  \u9000\u8d27\u6570\u91cf:{2}";
        String note = MessageFormat.format(notePattern, refundParamDto.getNote(), refundParamDto.getCanUse() != false ? "\u662f" : "\u5426", refundParamDto.getQuantity());
        operLog.setNote(note);
        this.operLogDao.insert(operLog);
        ProdReturnRecord prodReturnRecord = new ProdReturnRecord();
        prodReturnRecord.setCount(refundParamDto.getQuantity());
        prodReturnRecord.setNote(refundParamDto.getNote());
        prodReturnRecord.setOrderCreateTime(orderItemForUpdate.getCreateTime());
        prodReturnRecord.setOrderOpTime(orderOpTime);
        prodReturnRecord.setOrderItem(orderItemForUpdate);
        prodReturnRecord.setStatus(3);
        prodReturnRecord.setType(2);
        this.prodReturnRecordDao.insert(prodReturnRecord);
    }

    @Override
    public void buildDetail(OrderItem orderItem) {
        if (orderItem != null) {
            Order order = (Order)this.orderService.getById(orderItem.getOrder().getId());
            order.setUser((User)this.userService.getById(order.getUser().getId()));
            Sku sku = (Sku)this.skuService.getById(orderItem.getSku().getId());
            Product product = (Product)this.productService.getById(sku == null ? -1L : sku.getProduct().getId());
            product.setSupplier((Supplier)this.supplierService.getById(product == null ? -1L : product.getSupplier().getId()));
            sku.setProduct(product);
            orderItem.setSku(sku);
            orderItem.setOrder(order);
            DictExpress express = orderItem.getExpress();
            if (express != null && express.getId() != null) {
                orderItem.setExpress((DictExpress)this.expressService.getById(express.getId()));
            }
        }
    }

    @Override
    public void updateSalesOrderItemsForBitchSend(List<OrderBitchSendImportExcelDto> canSendOrderDtos, AdminUser loginedUser) {
        for (OrderBitchSendImportExcelDto sendDto : canSendOrderDtos) {
            OrderItem updateItem = new OrderItem();
            updateItem.setStatus(OrderItem.Status.SENDING);
            updateItem.setExpress(new DictExpress(sendDto.getExpressId()));
            updateItem.setTransportNo(sendDto.getTransportNo());
            updateItem.setId(sendDto.getOrderItem().getId());
            super.update(updateItem);
            this.skuService.decreaseStockAndOccupiedOnSend(sendDto.getOrderItem().getSku().getId(), sendDto.getOrderItem().getQuantity());
        }
        this.skuService.batchClearCachedSkus(Collections3.extractToList(canSendOrderDtos, (String)"orderItem.sku.id"));
        this.batchClearCachedOrderItems(Collections3.extractToList(canSendOrderDtos, (String)"orderItem.id"));
        ArrayList operationLogs = Lists.newArrayList();
        Date logDateTime = new Date();
        for (OrderBitchSendImportExcelDto dto : canSendOrderDtos) {
            OrderItemOperationLog operLog = new OrderItemOperationLog();
            operLog.setOperator(loginedUser);
            operLog.setLogTime(logDateTime);
            operLog.setOrderItem(dto.getOrderItem());
            operLog.setOperation(OrderItem.OrderAction.BATCH_SEND.getName());
            operLog.setNote("\u6279\u91cf\u53d1\u8d27");
            operationLogs.add(operLog);
        }
        this.operLogDao.batchInsert(operationLogs);
    }

    private void batchClearCachedOrderItems(List<Long> odrItemIdList) {
        String itemCacheKeyPrev = "'cache.sale_order_item.'+";
        itemCacheKeyPrev = StringUtils.substringBetween((String)itemCacheKeyPrev, (String)"'");
        ArrayList itemCacheKeyList = Lists.newArrayListWithExpectedSize((int)odrItemIdList.size());
        for (Long itemId : odrItemIdList) {
            itemCacheKeyList.add(itemCacheKeyPrev + itemId);
        }
        this.jedisTemplate.del(itemCacheKeyList.toArray(new String[0]));
    }

    @Override
    public List<OrderItemOperationLog> findOperationLogByOrderItemId(Long orderItemId) {
        return this.operLogDao.findByOrderItemId(orderItemId);
    }

    @Override
    public StatusDto importToSend(List<OrderBitchSendImportExcelDto> sendOrderList, AdminUser operator) {
        List orderCodes = Lists.newArrayList();
        List expressCodes = Lists.newArrayList();
        if (!CollectionUtils.isNotEmpty(sendOrderList)) {
            return StatusDto.buildFailureStatusDto("\u5bfc\u5165\u5931\u8d25! \u8bf7\u586b\u5199\u6570\u636e");
        }
        orderCodes = Collections3.extractToList(sendOrderList, (String)"orderCode");
        expressCodes = Collections3.extractToList(sendOrderList, (String)"expressCode");
        List<OrderItem> orderItems = this.findDealedOrderItemsByCodesIn(orderCodes);
        if (CollectionUtils.isEmpty(orderItems)) {
            return StatusDto.buildFailureStatusDto("\u5bfc\u5165\u5931\u8d25! \u6ca1\u6709\u53ef\u4ee5\u53d1\u8d27\u7684\u7684\u8ba2\u5355");
        }
        Map<String, DictExpress> expressMap = this.expressService.findExpressMapByCodesIn(expressCodes);
        if (expressMap.isEmpty()) {
            return StatusDto.buildFailureStatusDto("\u5bfc\u5165\u5931\u8d25! \u6ca1\u6709\u5bf9\u5e94\u7684\u5feb\u9012\u516c\u53f8\u8bb0\u5f55");
        }
        HashMap dealedItemMap = Maps.newHashMap();
        for (OrderItem ordItem : orderItems) {
            dealedItemMap.put(ordItem.getOrderCode(), ordItem);
        }
        ArrayList canUpdateDtos = Lists.newArrayList();
        ArrayList canNotUpdateDtos = Lists.newArrayList();
        for (OrderBitchSendImportExcelDto dto : sendOrderList) {
            int correctFieldCount = 0;
            OrderBitchSendImportExcelFailDto failDto = null;
            StringBuffer errorMsgBuf = new StringBuffer();
            if (StringUtils.isBlank((CharSequence)dto.getOrderCode()) || !dealedItemMap.containsKey(dto.getOrderCode())) {
                errorMsgBuf.append("\u8ba2\u5355\u4e0d\u5b58\u5728;");
            } else {
                ++correctFieldCount;
                OrderItem item = (OrderItem)dealedItemMap.get(dto.getOrderCode());
                dto.setOrderItem(item);
                ++correctFieldCount;
            }
            if (expressMap.containsKey(dto.getExpressCode()) && expressMap.get(dto.getExpressCode()).getStatus() == Status.OPEN) {
                dto.setExpressId(expressMap.get(dto.getExpressCode()).getId());
                ++correctFieldCount;
            } else {
                errorMsgBuf.append("\u5feb\u9012\u516c\u53f8\u4e0d\u5b58\u5728\u6216\u5df2\u505c\u7528;");
            }
            if (StringUtils.isNotEmpty((CharSequence)dto.getTransportNo())) {
                ++correctFieldCount;
            } else {
                errorMsgBuf.append("\u8fd0\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff1b");
            }
            if (correctFieldCount == 4) {
                canUpdateDtos.add(dto);
                continue;
            }
            failDto = new OrderBitchSendImportExcelFailDto();
            failDto.setExpressCode(dto.getExpressCode());
            failDto.setOrderCode(dto.getOrderCode());
            failDto.setTransportNo(dto.getTransportNo());
            failDto.setFailMsg(errorMsgBuf.toString());
            canNotUpdateDtos.add(failDto);
        }
        if (CollectionUtils.isNotEmpty((Collection)canUpdateDtos)) {
            this.updateSalesOrderItemsForBitchSend(canUpdateDtos, operator);
        }
        if (Collections3.isNotEmpty((Collection)canNotUpdateDtos)) {
            StatusDto<String> res = StatusDto.buildFailureStatusDto();
            HashMap resMap = Maps.newHashMapWithExpectedSize((int)2);
            resMap.put("canUpdateDtos", canUpdateDtos);
            resMap.put("canNotUpdateDtos", canNotUpdateDtos);
            res.setData((String)((Object)resMap));
            return res;
        }
        return StatusDto.buildSuccessStatusDto("\u5bfc\u5165\u5b8c\u6210");
    }

    @Override
    public Map<String, Long> statisOrderNumGroupByStatus(Long userId) {
        List<Map<String, Object>> orderNumRowList;
        HashMap statusQtyMap = null;
        if (userId > 0L && !CollectionUtils.isEmpty(orderNumRowList = ((OrderItemDao)this.entityDao).statisOrderNumGroupByStatus(userId))) {
            Long totalCnt = 0L;
            statusQtyMap = Maps.newHashMapWithExpectedSize((int)orderNumRowList.size());
            for (Map<String, Object> rowMapper : orderNumRowList) {
                String status = rowMapper.get("status").toString();
                statusQtyMap.put(status, (Long)rowMapper.get("orderNum"));
                totalCnt = totalCnt + (Long)rowMapper.get("orderNum");
            }
            statusQtyMap.put("total", totalCnt);
        }
        if (statusQtyMap == null) {
            statusQtyMap = Collections.emptyMap();
        }
        return statusQtyMap;
    }

    @Override
    public void insertItems(List<OrderItem> items) {
        for (OrderItem item : items) {
            ((OrderItemDao)this.entityDao).insert(item);
        }
    }

    @Override
    @Transactional(isolation=Isolation.READ_COMMITTED, propagation=Propagation.REQUIRED)
    public void batchUpdateStatus(OrderItem.Status outStatus, OrderItem.AdmStatus inStatus, List<Long> ids) {
        if (ids == null || ids.size() == 0) {
            throw new ServiceException("\u5b50\u8ba2\u5355id\u4e3a\u7a7a\uff01");
        }
        ((OrderItemDao)this.entityDao).batchUpdateStatus(outStatus, inStatus, ids);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SendSMS
    implements Runnable {
        private List<CardDeliverRecord> recordList;
        private String skuName;
        private Long userId;

        public SendSMS(List<CardDeliverRecord> records, String skuName, Long userId) {
            this.recordList = records;
            this.skuName = skuName;
            this.userId = userId;
        }

        @Override
        public void run() {
            try {
                if (this.recordList == null || this.recordList.size() == 0) {
                    OrderItemService.this.logger.info("\u6ca1\u6709\u53d1\u8d27\u8bb0\u5f55.");
                    return;
                }
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                User u = (User)OrderItemService.this.userService.getById(this.userId);
                String content = "\u60a8\u5df2\u6210\u529f\u5151\u6362%s\uff0c\u8bf7\u59a5\u5584\u4fdd\u7ba1\uff0c\u5982\u6709\u95ee\u9898\u8bf7\u8054\u7cfb\u5ba2\u670d4000108068\u3002";
                StringBuffer smsInfo = new StringBuffer(100);
                smsInfo.append(this.skuName.trim()).append(":");
                int j = this.recordList.size();
                for (int i = 0; i < j; ++i) {
                    CardDeliverRecord cdr = this.recordList.get(i);
                    long vpId = cdr.getVirtualProductId();
                    VirtualProduct virtualProduct = (VirtualProduct)OrderItemService.this.virtualProductService.getById(vpId);
                    if (virtualProduct.getType().equals((Object)VirtualProduct.Type.CARD_PWD)) {
                        smsInfo.append("\u5361\u53f7").append(virtualProduct.getCardno()).append("\uff0c");
                        smsInfo.append("\u5bc6\u7801").append(virtualProduct.getPasswd()).append("\uff0c");
                        smsInfo.append("\u6709\u6548\u671f\u81f3").append(sdf.format(virtualProduct.getExpired())).append("\uff0c");
                    } else if (virtualProduct.getType() == VirtualProduct.Type.EXCHANGE_CODE) {
                        smsInfo.append("\u5151\u6362\u7801").append(virtualProduct.getPasswd()).append("\uff0c");
                        smsInfo.append("\u6709\u6548\u671f\u81f3").append(sdf.format(virtualProduct.getExpired())).append("\uff0c");
                    }
                    if (i == j - 1) continue;
                    smsInfo.deleteCharAt(smsInfo.length() - 1);
                    smsInfo.append(";");
                }
                boolean status = false;
                if (status) {
                    OrderItemService.this.logger.info("\u77ed\u4fe1\u53d1\u9001\u6210\u529f");
                    for (CardDeliverRecord cdr : this.recordList) {
                        cdr.setDeliverStatus(CardDeliverRecord.DeliverStatus.SUCCESS);
                        OrderItemService.this.cardDeliverRecordService.update(cdr);
                    }
                } else {
                    OrderItemService.this.logger.info("\u77ed\u4fe1\u53d1\u9001\u5931\u8d25");
                    for (CardDeliverRecord cdr : this.recordList) {
                        cdr.setDeliverStatus(CardDeliverRecord.DeliverStatus.FAILED);
                        OrderItemService.this.cardDeliverRecordService.update(cdr);
                    }
                }
            }
            catch (Exception e) {
                OrderItemService.this.logger.info("\u77ed\u4fe1\u53d1\u9001\u5931\u8d25");
                for (CardDeliverRecord cdr : this.recordList) {
                    cdr.setDeliverStatus(CardDeliverRecord.DeliverStatus.FAILED);
                    OrderItemService.this.cardDeliverRecordService.update(cdr);
                }
            }
        }
    }
}

