/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.service.impl.order;

import com.google.common.collect.Maps;
import com.rocoinfo.rocomall.common.service.CrudService;
import com.rocoinfo.rocomall.common.service.ServiceException;
import com.rocoinfo.rocomall.entity.order.OrderItem;
import com.rocoinfo.rocomall.entity.order.OrderOutStore;
import com.rocoinfo.rocomall.repository.order.OrderOutStoreDao;
import com.rocoinfo.rocomall.service.impl.product.SkuService;
import com.rocoinfo.rocomall.service.order.IOrderOutStoreService;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class OrderOutStoreService
extends CrudService<OrderOutStoreDao, OrderOutStore>
implements IOrderOutStoreService {
    @Autowired
    private SkuService skuService;

    @Override
    public List<OrderOutStore> getMergeOrderOutStore(long dictWarehouseId, long dictExpressId, String skuCode) {
        return ((OrderOutStoreDao)this.entityDao).getMergeOrderOutStore(dictWarehouseId, dictExpressId, skuCode);
    }

    @Override
    public Page<OrderOutStore> searchOutstoreRecordsByProdId(Long productId, Pageable pageable) {
        List<Object> pageData = Collections.emptyList();
        Long count = 0L;
        if (productId != null && productId > 0L) {
            HashMap params = Maps.newHashMap();
            params.put("productId", productId);
            params.put("offset", pageable.getPageNumber());
            params.put("pageSize", pageable.getPageSize());
            params.put("sort", pageable.getSort());
            count = ((OrderOutStoreDao)this.entityDao).searchTotalOutstoreRecordsByProdId(params);
            if (count > 0L) {
                pageData = ((OrderOutStoreDao)this.entityDao).searchOutstoreRecordsByProdId(params);
            }
        }
        return new PageImpl(pageData, pageable, count.longValue());
    }

    @Override
    @Transactional(isolation=Isolation.READ_COMMITTED)
    public void execOutStore(OrderOutStore outStoreOrder) {
        ((OrderOutStoreDao)this.entityDao).update(outStoreOrder);
        this.upDateOrderItemStatus(OrderItem.Status.RECEIVING, OrderItem.AdmStatus.DISTRIBUTION_OUTED, outStoreOrder.getId());
        if (outStoreOrder.getState().booleanValue()) {
            long skuId = outStoreOrder.getSku().getId();
            int quantity = -outStoreOrder.getQuantity();
            this.skuService.incrOrDecrStock(skuId, quantity, null);
        }
    }

    @Override
    @Transactional(isolation=Isolation.READ_COMMITTED)
    public void upDateOrderItemStatus(OrderItem.Status outStatus, OrderItem.AdmStatus inStatus, Long id) {
        if (id == null || outStatus == null || inStatus == null) {
            throw new ServiceException("\u5b50\u8ba2\u5355\u72b6\u6001\u5f02\u5e38\uff01");
        }
        ((OrderOutStoreDao)this.entityDao).upDateOrderItemStatus(outStatus, inStatus, id);
    }
}

