/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.service.impl.product;

import com.rocoinfo.rocomall.common.service.CrudService;
import com.rocoinfo.rocomall.common.service.ServiceException;
import com.rocoinfo.rocomall.entity.Brand;
import com.rocoinfo.rocomall.repository.BrandDao;
import com.rocoinfo.rocomall.service.IUploadService;
import com.rocoinfo.rocomall.service.product.IBrandService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class BrandService
extends CrudService<BrandDao, Brand>
implements IBrandService {
    @Autowired
    private IUploadService uploadService;

    @Transactional(isolation=Isolation.READ_COMMITTED, readOnly=true)
    public Page<Brand> findBrandByPage(Map<String, Object> params, Pageable pageable) {
        if (params == null) {
            params = new HashMap<String, Object>();
        }
        params.put("offset", pageable.getOffset());
        params.put("pageSize", pageable.getPageSize());
        params.put("sort", pageable.getSort());
        List pageData = ((BrandDao)this.entityDao).search(params);
        Long count = ((BrandDao)this.entityDao).searchTotal(params);
        PageImpl page = new PageImpl(pageData, pageable, count.longValue());
        return page;
    }

    @Override
    public void insert(Brand brand) {
        if (StringUtils.isNotBlank((CharSequence)brand.getImagePath())) {
            brand.setImagePath(this.uploadService.submitPath(brand.getImagePath()));
        }
        super.insert(brand);
    }

    @Override
    public void update(Brand brand) {
        Brand oldBrand = (Brand)this.getById(brand.getId());
        if (brand == null || oldBrand == null) {
            throw new ServiceException("\u54c1\u724c\u5bf9\u8c61\u4e3a\u7a7a,\u65e0\u6cd5\u66f4\u65b0");
        }
        if (brand.getImagePath() != null && StringUtils.isNotBlank((CharSequence)brand.getImagePath())) {
            brand.setImagePath(this.uploadService.updateFile(brand.getImagePath(), oldBrand.getImagePath()));
        }
        super.update(brand);
    }
}

