/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.service.impl.product;

import com.google.common.collect.Lists;
import com.rocoinfo.rocomall.common.service.CrudService;
import com.rocoinfo.rocomall.common.service.ServiceException;
import com.rocoinfo.rocomall.entity.Catalog;
import com.rocoinfo.rocomall.repository.CatalogDao;
import com.rocoinfo.rocomall.service.impl.UploadService;
import com.rocoinfo.rocomall.service.product.ICatalogService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.aop.framework.AopContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.Cache;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class CatalogService
extends CrudService<CatalogDao, Catalog>
implements ICatalogService {
    @Autowired
    private UploadService uploadService;

    @Override
    @Cacheable(value={"cache"}, key="'cache.catalog.all'")
    public List<Catalog> findAll() {
        return super.findAll();
    }

    @Override
    protected void evictCacheEntitysHook() {
        String allCatalogCacheKey = StringUtils.substringBetween((String)"'cache.catalog.all'", (String)"'");
        Cache cache = this.cacheManager.getCache("cache");
        cache.evict((Object)allCatalogCacheKey);
    }

    public void save(Catalog catalog) {
        if (catalog.getId() == null) {
            catalog.setId(0L);
        }
        if (this.isExistCatalogName(catalog)) {
            throw new ServiceException("\u5206\u7c7b\u540d\u79f0\u5df2\u7ecf\u5b58\u5728!");
        }
        if (StringUtils.isNotBlank((CharSequence)catalog.getImgUrl())) {
            catalog.setImgUrl(this.uploadService.submitPath(catalog.getImgUrl()));
        }
        super.insert(catalog);
    }

    @Override
    public void update(Catalog catalog) {
        if (this.isExistCatalogName(catalog)) {
            throw new ServiceException("\u5206\u7c7b\u540d\u79f0\u5df2\u7ecf\u5b58\u5728!");
        }
        Catalog oldCatalog = (Catalog)this.getById(catalog.getId());
        if (StringUtils.isNotBlank((CharSequence)catalog.getImgUrl())) {
            catalog.setImgUrl(this.uploadService.updateFile(catalog.getImgUrl(), oldCatalog.getImgUrl()));
        }
        super.update(catalog);
    }

    @Override
    public List<Catalog> findSubCatalogs(long parentId, Catalog.Status ... states) {
        ArrayList subCatalogs = Collections.emptyList();
        List<Catalog> allCatalogs = this.getCurrentProxy().findAll();
        if (!CollectionUtils.isEmpty(allCatalogs)) {
            subCatalogs = Lists.newArrayList();
            for (Catalog cate : allCatalogs) {
                if (!ArrayUtils.isEmpty((Object[])states) && !ArrayUtils.contains((Object[])states, (Object)((Object)cate.getStatus()))) continue;
                if (parentId > 0L) {
                    if (cate.getParent() == null || cate.getParent().getId() != parentId) continue;
                    subCatalogs.add(cate);
                    continue;
                }
                if (cate.getParent() != null && cate.getParent().getId() != null && cate.getParent().getId() >= 1L) continue;
                subCatalogs.add(cate);
            }
        }
        return subCatalogs;
    }

    @Override
    public List<Catalog> buildCatalogTree(boolean isRequireTreeLine) {
        List<Catalog> allCatalogs = this.getCurrentProxy().findAll();
        if (!CollectionUtils.isEmpty(allCatalogs)) {
            ArrayList prodTypeTree = Lists.newArrayList();
            for (Catalog prodType : this.findTopCatalogs(allCatalogs)) {
                this.recurse(prodType, prodTypeTree, allCatalogs, 0, isRequireTreeLine);
            }
            return prodTypeTree;
        }
        return allCatalogs;
    }

    private void recurse(Catalog curCatalog, List<Catalog> tree, List<Catalog> allCatalog, int depth, boolean isRequireTreeLine) {
        if (curCatalog != null) {
            if (isRequireTreeLine) {
                String name = curCatalog.getName();
                if (depth == 0) {
                    name = "\u254b" + name;
                } else {
                    String blank = "";
                    for (int i = 0; i < depth; ++i) {
                        blank = blank + "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
                    }
                    name = blank + "\u251c" + name;
                }
                curCatalog.setName(name);
            }
            tree.add(curCatalog);
            List<Catalog> childCateList = this.findSubCatelogs(curCatalog.getId(), allCatalog);
            Iterator<Catalog> iter = childCateList.iterator();
            while (iter.hasNext()) {
                this.recurse(iter.next(), tree, allCatalog, depth + 1, isRequireTreeLine);
            }
        }
    }

    private List<Catalog> findSubCatelogs(long parentId, List<Catalog> allCatalogs) {
        ArrayList subCateList = Lists.newArrayList();
        for (Catalog catalog : allCatalogs) {
            if (catalog == null || catalog.getParent() == null || catalog.getParent().getId() != parentId) continue;
            subCateList.add(catalog);
        }
        return subCateList;
    }

    private List<Catalog> findTopCatalogs(List<Catalog> allCatalogs) {
        if (CollectionUtils.isEmpty(allCatalogs)) {
            return allCatalogs;
        }
        ArrayList topCatalogs = Lists.newArrayList();
        for (Catalog cate : allCatalogs) {
            if (cate == null || cate.getParent() != null && cate.getParent().getId() >= 1L) continue;
            topCatalogs.add(cate);
        }
        return topCatalogs;
    }

    @Override
    public List<Catalog> findByCatalogIds(List<Long> catalogIds) {
        ArrayList<Catalog> productCatalogs = new ArrayList<Catalog>();
        for (Long catalogId : catalogIds) {
            productCatalogs.add((Catalog)this.getById(catalogId));
        }
        return productCatalogs;
    }

    @Override
    public List<Long> findSubTreeIds(Long id) {
        List<Catalog> catalogs = this.getCurrentProxy().findAll();
        HashMap<Long, Catalog> idToCatalog = new HashMap<Long, Catalog>(catalogs.size());
        for (Catalog catalog : catalogs) {
            idToCatalog.put(catalog.getId(), catalog);
        }
        ArrayList<Long> subTreeIds = new ArrayList<Long>();
        subTreeIds.add(id);
        block3: for (Catalog catalog : catalogs) {
            if (id.equals(catalog.getId())) continue;
            Long parentId = catalog.getParentId();
            while (parentId != null) {
                if (parentId.equals(id)) {
                    subTreeIds.add(catalog.getId());
                    continue block3;
                }
                try {
                    parentId = ((Catalog)idToCatalog.get(parentId)).getParentId();
                }
                catch (Exception e) {
                    continue block3;
                }
            }
        }
        return subTreeIds;
    }

    @Override
    public List<Catalog> tree(boolean isAll) {
        List<Catalog> catalogs = this.getCurrentProxy().findAll();
        HashMap<Long, Catalog> catalogMap = new HashMap<Long, Catalog>(catalogs.size());
        for (Catalog catalog : catalogs) {
            if (!isAll && catalog.getStatus() == Catalog.Status.INVISIBLE) continue;
            catalogMap.put(catalog.getId(), catalog);
        }
        ArrayList<Catalog> root = new ArrayList<Catalog>();
        for (Catalog catalog : catalogs) {
            if (!isAll && catalog.getStatus() == Catalog.Status.INVISIBLE) continue;
            if (catalog.getParentId() == null) {
                root.add(catalog);
                continue;
            }
            if (catalogMap.get(catalog.getParentId()) == null) continue;
            List<Catalog> children = ((Catalog)catalogMap.get(catalog.getParentId())).getChildren();
            if (children == null) {
                children = new ArrayList<Catalog>();
                ((Catalog)catalogMap.get(catalog.getParentId())).setChildren(children);
            }
            children.add(catalog);
        }
        return root;
    }

    @Override
    public List<Long> findCatalogIdsbyName(String name) {
        ArrayList list = new ArrayList();
        if (name == null || name.equals("")) {
            return null;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("name", name);
        params.put("offset", 0);
        params.put("pageSize", Integer.MAX_VALUE);
        params.put("parentId", 0);
        List search = ((CatalogDao)this.entityDao).search(params);
        HashSet<Long> set = new HashSet<Long>();
        if (search != null && search.size() > 0) {
            for (Catalog c : search) {
                List<Long> findSubTreeIds = this.findSubTreeIds(c.getId());
                set.addAll(findSubTreeIds);
            }
        } else {
            return null;
        }
        ArrayList<Long> result = new ArrayList<Long>();
        result.addAll(set);
        return result;
    }

    private boolean isExistCatalogName(Catalog catalog) {
        if (catalog == null || StringUtils.isBlank((CharSequence)catalog.getName())) {
            throw new ServiceException("\u5206\u7c7b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        for (Catalog cate : this.getCurrentProxy().findAll()) {
            if (catalog.getId() != null && catalog.getId() == catalog.getId() && StringUtils.equals((CharSequence)cate.getName(), (CharSequence)catalog.getName())) {
                return false;
            }
            if (!cate.getName().equals(catalog.getName())) continue;
            return true;
        }
        return false;
    }

    private CatalogService getCurrentProxy() {
        return (CatalogService)AopContext.currentProxy();
    }
}

