/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.service.impl.product;

import com.google.common.collect.Lists;
import com.rocoinfo.rocomall.common.service.CrudService;
import com.rocoinfo.rocomall.common.service.ServiceException;
import com.rocoinfo.rocomall.entity.Supplier;
import com.rocoinfo.rocomall.repository.SupplierDao;
import com.rocoinfo.rocomall.service.product.ISupplierService;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.aop.framework.AopContext;
import org.springframework.cache.Cache;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class SupplierService
extends CrudService<SupplierDao, Supplier>
implements ISupplierService {
    @Override
    public List<Supplier> findSuppliers(Boolean useable) {
        List<Object> supplierList = Lists.newArrayList();
        List<Supplier> all = this.getProxy().findAll();
        if (useable == null) {
            supplierList = all;
        } else {
            for (Supplier supplyer : all) {
                if (!supplyer.getUseable().equals(useable)) continue;
                supplierList.add(supplyer);
            }
        }
        return supplierList;
    }

    @Override
    @Cacheable(value={"cache"}, key="'cache.supplier.all'")
    public List<Supplier> findAll() {
        return super.findAll();
    }

    @Override
    protected void evictCacheEntitysHook() {
        Cache cache = this.cacheManager.getCache("cache");
        cache.evict((Object)StringUtils.substringBetween((String)"'cache.supplier.all'", (String)"'"));
    }

    @Override
    public void insert(Supplier entity) {
        if (this.isExitCode(entity.getCode())) {
            throw new ServiceException("\u4f9b\u5e94\u5546\u7f16\u7801\u5df2\u7ecf\u5b58\u5728");
        }
        if (this.isExitName(entity.getName())) {
            throw new ServiceException("\u4f9b\u5e94\u5546\u540d\u79f0\u5df2\u7ecf\u5b58\u5728");
        }
        entity.setUseable(true);
        super.insert(entity);
    }

    @Override
    public void update(Supplier entity) {
        Supplier dbsupplier = (Supplier)this.getById(entity.getId());
        if (StringUtils.isNotEmpty((CharSequence)entity.getCode()) && !StringUtils.equalsIgnoreCase((CharSequence)entity.getCode(), (CharSequence)dbsupplier.getCode()) && this.isExitCode(entity.getCode())) {
            throw new ServiceException("\u4f9b\u5e94\u5546\u7f16\u7801\u5df2\u7ecf\u5b58\u5728");
        }
        if (StringUtils.isNotEmpty((CharSequence)entity.getName()) && !StringUtils.equalsIgnoreCase((CharSequence)entity.getName(), (CharSequence)dbsupplier.getName()) && this.isExitName(entity.getName())) {
            throw new ServiceException("\u4f9b\u5e94\u5546\u540d\u79f0\u5df2\u7ecf\u5b58\u5728");
        }
        super.update(entity);
    }

    private boolean isExitCode(String code) {
        return ((SupplierDao)this.entityDao).isExitCode(code) > 0;
    }

    private boolean isExitName(String name) {
        return ((SupplierDao)this.entityDao).isExitName(name) > 0;
    }

    @Override
    public List<Supplier> findUseableSupplysByAdminId(Long adminId) {
        return ((SupplierDao)this.entityDao).findUseableSupplysByAdminId(adminId);
    }

    private SupplierService getProxy() {
        return (SupplierService)AopContext.currentProxy();
    }
}

