/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.service.impl.wx;

import com.rocoinfo.rocomall.Constants;
import com.rocoinfo.rocomall.common.service.CrudService;
import com.rocoinfo.rocomall.common.service.ServiceException;
import com.rocoinfo.rocomall.dto.StatusDto;
import com.rocoinfo.rocomall.entity.Address;
import com.rocoinfo.rocomall.entity.insurance.InsuranceInfo;
import com.rocoinfo.rocomall.entity.wx.InsuranceBuyRecord;
import com.rocoinfo.rocomall.pay.MD5;
import com.rocoinfo.rocomall.redis.JedisTemplate;
import com.rocoinfo.rocomall.repository.insurance.InsuranceInfoDao;
import com.rocoinfo.rocomall.repository.wx.InsuranceBuyRecordDao;
import com.rocoinfo.rocomall.service.IAddressService;
import com.rocoinfo.rocomall.service.wx.IHitGoldEggService;
import com.rocoinfo.rocomall.utils.JsonUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springside.modules.utils.Collections3;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class HitGoldEggService
extends CrudService<InsuranceBuyRecordDao, InsuranceBuyRecord>
implements IHitGoldEggService {
    @Autowired
    private InsuranceInfoDao insuranceInfoDao;
    @Autowired
    private IAddressService addressService;
    @Autowired
    private JedisTemplate jedisTemplate;

    @Override
    public List<String> createPrizePool(int[][] meta) {
        ArrayList<String> pool = new ArrayList<String>();
        for (int[] arr : meta) {
            for (int i = 0; i < arr[1]; ++i) {
                pool.add(String.valueOf(arr[0]));
            }
        }
        Random random = new Random();
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < pool.size(); ++j) {
                int index1 = random.nextInt(pool.size() - 1);
                String temp = (String)pool.get(index1);
                pool.set(index1, (String)pool.get(j));
                pool.set(j, temp);
            }
        }
        String[] result = pool.toArray(new String[pool.size()]);
        this.jedisTemplate.lpush(Constants.HIT_GOLD_EGG_POOL, result);
        return pool;
    }

    @Override
    public void initPrizePool(int[][] meta) {
        if (meta == null) {
            return;
        }
        if (((InsuranceBuyRecordDao)this.entityDao).getGuessRecordCount(null) < 1) {
            this.jedisTemplate.del(Constants.HIT_GOLD_EGG_POOL);
            this.jedisTemplate.del(Constants.HIT_GOLD_EGG_COUNT);
            this.createPrizePool(meta);
        }
    }

    @Override
    public String guessGoldEggResult() {
        return this.jedisTemplate.lpop(Constants.HIT_GOLD_EGG_POOL);
    }

    @Override
    @Transactional(isolation=Isolation.READ_COMMITTED, propagation=Propagation.REQUIRED)
    public StatusDto hitEgg(String openId) {
        List<InsuranceBuyRecord> records = ((InsuranceBuyRecordDao)this.entityDao).getHitChanceByOpenId(openId);
        if (CollectionUtils.isEmpty(records) || records.size() < 1) {
            return StatusDto.buildStatusDto("\u4e0d\u80fd\u53c2\u4e0e", "2");
        }
        if (!this.jedisTemplate.hasKey(Constants.HIT_GOLD_EGG_POOL)) {
            int recordCount = ((InsuranceBuyRecordDao)this.entityDao).getGuessRecordCount(openId);
            if (recordCount > 0) {
                return StatusDto.buildStatusDto("\u5df2\u7ecf\u62bd\u5956\u8fc7\u4e00\u6b21", "3");
            }
            return StatusDto.buildStatusDto("\u6ca1\u6709\u5956\u54c1\u4e86", "5");
        }
        InsuranceBuyRecord record = (InsuranceBuyRecord)Collections3.getFirst(records);
        Long index = this.jedisTemplate.incr(Constants.HIT_GOLD_EGG_COUNT);
        if (index % 3L != 0L) {
            record.setGuessPrizeStatus(InsuranceBuyRecord.GuessPrizeStatus.NOHIT);
            ((InsuranceBuyRecordDao)this.entityDao).update(record);
            return StatusDto.buildStatusDto("\u6ca1\u6709\u4e2d\u5956", "4");
        }
        String prizeId = this.guessGoldEggResult();
        if (StringUtils.isBlank((CharSequence)prizeId)) {
            record.setGuessPrizeStatus(InsuranceBuyRecord.GuessPrizeStatus.NOHIT);
            ((InsuranceBuyRecordDao)this.entityDao).update(record);
            return StatusDto.buildStatusDto("\u6ca1\u6709\u5956\u54c1\u4e86", "5");
        }
        record.setGuessPrizeStatus(InsuranceBuyRecord.GuessPrizeStatus.HIT);
        record.setPrizeId(prizeId);
        ((InsuranceBuyRecordDao)this.entityDao).update(record);
        StatusDto mapDto = StatusDto.buildDataSuccessStatusDto("1");
        mapDto.setData(new HashMap());
        ((Map)mapDto.getData()).put("prizeId", prizeId);
        ((Map)mapDto.getData()).put("recordId", record.getId());
        return mapDto;
    }

    @Override
    public List<InsuranceBuyRecord> getHitRecordByOpenId(String openId) {
        return ((InsuranceBuyRecordDao)this.entityDao).getHitRecordByOpenId(openId);
    }

    @Override
    @Transactional(isolation=Isolation.READ_COMMITTED, propagation=Propagation.REQUIRED)
    public void saveAddress(Address address, Long recordId) {
        this.addressService.insert(address);
        InsuranceBuyRecord record = new InsuranceBuyRecord();
        record.setId(recordId);
        record.setAddress(address);
        ((InsuranceBuyRecordDao)this.entityDao).update(record);
    }

    @Override
    public InsuranceBuyRecord getByThirdOrderId(String thirdOrderId) {
        return ((InsuranceBuyRecordDao)this.entityDao).getByThirdOrderId(thirdOrderId);
    }

    @Override
    public void payNotice(InsuranceBuyRecord record) {
        InsuranceBuyRecord dbRecord = this.getByThirdOrderId(record.getThirdOrderId());
        if (dbRecord != null) {
            if (dbRecord.getPayStatus() == InsuranceBuyRecord.PayStatus.SUCCESS && record.getPayStatus() == InsuranceBuyRecord.PayStatus.FAIL) {
                throw new ServiceException("\u5df2\u7ecf\u652f\u4ed8\u6210\u529f,\u65e0\u6cd5\u66f4\u65b0");
            }
            record.setId(dbRecord.getId());
            this.update(dbRecord);
            return;
        }
        record.setTime(new Date());
        record.setGuessPrizeStatus(InsuranceBuyRecord.GuessPrizeStatus.INIT);
        this.insert(record);
    }

    @Override
    public List<InsuranceInfo> getInsuranceInfo(String openId, String policyNumber) {
        return this.insuranceInfoDao.selectSearch(openId, policyNumber);
    }

    @Override
    public InsuranceInfo getInsuranceById(Long id) {
        return (InsuranceInfo)this.insuranceInfoDao.getById(id);
    }

    @Override
    @Transactional(isolation=Isolation.READ_COMMITTED, propagation=Propagation.REQUIRED)
    public void saveByInsuranceInfo(InsuranceInfo info) {
        if (!StringUtils.equals((CharSequence)"1", (CharSequence)info.getPayStatus())) {
            return;
        }
        String jsonStr = JsonUtils.pojoToJson(info);
        String md5 = MD5.getMD5ofStr(jsonStr);
        if (Collections3.getFirst(this.insuranceInfoDao.selectSearch(null, md5)) != null) {
            return;
        }
        info.setTime(new Date());
        info.setMd5(md5);
        if (this.insuranceInfoDao.selectCountByIdno(info.getIdno()) == 0) {
            InsuranceBuyRecord record = new InsuranceBuyRecord();
            record.setThirdOrderId(md5);
            record.setPayStatus(InsuranceBuyRecord.PayStatus.SUCCESS);
            record.setTime(new Date());
            record.setOpenId(String.valueOf(info.getUserid()));
            record.setGuessPrizeStatus(InsuranceBuyRecord.GuessPrizeStatus.INIT);
            ((InsuranceBuyRecordDao)this.entityDao).insert(record);
        }
        this.insuranceInfoDao.insert(info);
    }
}

