/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.utils;

import com.google.common.collect.Lists;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpUtils {
    private static Logger logger = LoggerFactory.getLogger(HttpUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String get(String url, NameValuePair ... parameters) {
        if (StringUtils.isBlank((CharSequence)url)) {
            throw new IllegalArgumentException("get\u8bf7\u6c42\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String respTxt = "";
        HttpClient httpClient = HttpUtils.createHttpClientInstance();
        try {
            if (null != parameters && parameters.length > 0) {
                String encodedParams = HttpUtils.encodeParameters(parameters);
                url = -1 == url.indexOf("?") ? url + "?" + encodedParams : url + "&" + encodedParams;
            }
            HttpGet getMethod = new HttpGet(url);
            RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(4000).setConnectTimeout(2000).build();
            getMethod.setConfig(requestConfig);
            HttpResponse resp = httpClient.execute((HttpUriRequest)getMethod);
            if (resp.getStatusLine().getStatusCode() == 200) {
                respTxt = EntityUtils.toString((HttpEntity)resp.getEntity(), (String)"UTF-8");
            }
        }
        catch (Exception e) {
            logger.error("httpGet\u8bf7\u6c42\u5f02\u5e38\uff1a{},\u9519\u8bef\u8be6\u7ec6\u662f\uff1a{}", (Object)url, (Object)e.getMessage());
        }
        finally {
            HttpClientUtils.closeQuietly((HttpClient)httpClient);
        }
        return respTxt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String postJson(String postUrl, String json) {
        HttpClient client = HttpUtils.createHttpClientInstance();
        HttpPost post = new HttpPost(postUrl);
        String respResult = null;
        try {
            StringEntity stringEntity = new StringEntity(json, "UTF-8");
            stringEntity.setContentEncoding("UTF-8");
            stringEntity.setContentType("application/json");
            post.setEntity((HttpEntity)stringEntity);
            HttpResponse resp = client.execute((HttpUriRequest)post);
            if (resp.getStatusLine().getStatusCode() == 200) {
                HttpEntity entity = resp.getEntity();
                respResult = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            }
        }
        catch (Exception ex) {
            logger.error("httpPost json\u5f02\u5e38\uff1a{},\u9519\u8bef\u8be6\u7ec6\u662f\uff1a{}", (Object)postUrl, (Object)ex.getMessage());
        }
        finally {
            HttpClientUtils.closeQuietly((HttpClient)client);
        }
        return respResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String post(String postUrl, NameValuePair ... parameters) {
        HttpClient client = HttpUtils.createHttpClientInstance();
        String respResult = null;
        try {
            HttpResponse resp;
            HttpPost httPost = new HttpPost(postUrl);
            if (ArrayUtils.isNotEmpty((Object[])parameters)) {
                ArrayList params = Lists.newArrayList((Object[])parameters);
                httPost.setEntity((HttpEntity)new UrlEncodedFormEntity((List)params, "UTF-8"));
            }
            if ((resp = client.execute((HttpUriRequest)httPost)).getStatusLine().getStatusCode() == 200) {
                HttpEntity entity = resp.getEntity();
                respResult = EntityUtils.toString((HttpEntity)entity);
            }
        }
        catch (Exception ex) {
            logger.error("httpPost\u8bf7\u6c42\u53d1\u751f\u5f02\u5e38\uff1a\u5730\u5740\uff1a{},\u9519\u8bef\u8be6\u7ec6\u662f\uff1a{}", (Object)postUrl, (Object)ex.getMessage());
        }
        finally {
            HttpClientUtils.closeQuietly((HttpClient)client);
        }
        return respResult;
    }

    private static String encodeParameters(NameValuePair[] nameValues) {
        if (nameValues == null || nameValues.length == 0) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < nameValues.length; ++i) {
            NameValuePair nameValue = nameValues[i];
            if (i == 0) {
                buffer.append(nameValue.getName() + "=" + nameValue.getValue());
                continue;
            }
            buffer.append("&" + nameValue.getName() + "=" + nameValue.getValue());
        }
        return buffer.toString();
    }

    public static String encodeFilename(String filename, HttpServletRequest request) {
        String agent = request.getHeader("USER-AGENT");
        if (agent == null) {
            return filename;
        }
        try {
            if (-1 != agent.indexOf("MSIE")) {
                String newFileName = URLEncoder.encode(filename, "UTF-8");
                if ((newFileName = StringUtils.replace((String)newFileName, (String)"+", (String)"%20")).length() > 150) {
                    newFileName = new String(filename.getBytes("UTF-8"), "ISO8859-1");
                    newFileName = StringUtils.replace((String)newFileName, (String)" ", (String)"%20");
                }
                return newFileName;
            }
            if (-1 != agent.indexOf("Mozilla")) {
                return "=?UTF-8?B?" + new String(Base64.encodeBase64((byte[])filename.getBytes("UTF-8"))) + "?=";
            }
            return filename;
        }
        catch (Exception ex) {
            return filename;
        }
    }

    public static HttpClient createHttpClientInstance() {
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        RequestConfig.Builder reqConfigBuilder = RequestConfig.custom();
        reqConfigBuilder.setSocketTimeout(6000);
        reqConfigBuilder.setConnectTimeout(3000);
        reqConfigBuilder.setConnectionRequestTimeout(3000);
        RequestConfig reqConfig = reqConfigBuilder.build();
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(SSLContexts.createDefault(), SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        httpClientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf);
        httpClientBuilder.setDefaultRequestConfig(reqConfig);
        return httpClientBuilder.build();
    }

    public static String getAddress(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return (ip = ip.split(",")[0]).equals("0:0:0:0:0:0:0:1") ? "127.0.0.1" : ip;
    }
}

