/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.utils;

import com.fasterxml.jackson.databind.JavaType;
import com.rocoinfo.rocomall.utils.XStreamUtils;
import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.ReflectionUtils;
import org.springside.modules.mapper.JsonMapper;
import org.springside.modules.web.Servlets;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonUtils {
    public static final String EXCEL_TYPE = "application/vnd.ms-excel";
    public static final String HTML_TYPE = "text/html";
    public static final String JS_TYPE = "text/javascript";
    public static final String JSON_TYPE = "application/json";
    public static final String XML_TYPE = "text/xml";
    public static final String TEXT_TYPE = "text/plain";
    private static final String HEADER_ENCODING = "encoding";
    private static final String HEADER_NOCACHE = "no-cache";
    private static final boolean DEFAULT_NOCACHE = true;
    public static final String MESSAGE_ATTRIBUTE_NAME = "actionMessage";
    public static final String CALL_BACK = "callback";
    public static final JsonMapper normalMapper = new JsonMapper();
    public static final XStream xStream = XStreamUtils.getDefaultXStream();

    public static void renderText(HttpServletResponse response, String jsonText, String ... headers) {
        JsonUtils.render(response, TEXT_TYPE, jsonText, headers);
    }

    public static void render(HttpServletResponse response, String contentType, String content, String ... headers) {
        JsonUtils.initResponseHeader(response, contentType, headers);
        try {
            response.getWriter().write(content);
            response.getWriter().flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static void renderJson(HttpServletResponse response, Object data, String ... headers) {
        JsonUtils.render(response, TEXT_TYPE, JsonUtils.pojoToJson(data), headers);
    }

    public static void renderJsonp(HttpServletResponse response, Object data, String ... headers) {
        JsonUtils.render(response, TEXT_TYPE, JsonUtils.pojoToJsonp(data), headers);
    }

    public static void renderJsonp(HttpServletResponse response, String callbackName, Object data, String ... headers) {
        JsonUtils.render(response, TEXT_TYPE, JsonUtils.pojoToJsonp(callbackName, data), headers);
    }

    public static void renderXml(HttpServletResponse response, Object data, String ... headers) {
        JsonUtils.render(response, XML_TYPE, xStream.toXML(data), headers);
    }

    public static String pojoToJson(Object obj) {
        String json = "";
        if (obj != null) {
            json = normalMapper.toJson(obj);
        }
        return json;
    }

    public static String pojoNotEmptyToJson(Object obj) {
        String json = "";
        if (obj != null) {
            json = JsonMapper.nonEmptyMapper().toJson(obj);
        }
        return json;
    }

    public static String pojoToJsonp(Object obj) {
        return JsonUtils.pojoToJsonp(CALL_BACK, obj);
    }

    public static String pojoToJsonp(String callbackName, Object obj) {
        String json = "";
        if (obj != null) {
            json = normalMapper.toJsonP(callbackName, obj);
        }
        return json;
    }

    private static HttpServletResponse initResponseHeader(HttpServletResponse response, String contentType, String ... headers) {
        String encoding = "UTF-8";
        boolean noCache = true;
        if (headers != null && headers.length > 0) {
            for (String header : headers) {
                String headerName = StringUtils.substringBefore((String)header, (String)":");
                String headerValue = StringUtils.substringAfter((String)header, (String)":");
                if (StringUtils.equalsIgnoreCase((CharSequence)headerName, (CharSequence)HEADER_ENCODING)) {
                    encoding = headerValue;
                    continue;
                }
                if (StringUtils.equalsIgnoreCase((CharSequence)headerName, (CharSequence)HEADER_NOCACHE)) {
                    noCache = Boolean.parseBoolean(headerValue);
                    continue;
                }
                throw new IllegalArgumentException(headerName + "\u4e0d\u662f\u4e00\u4e2a\u5408\u6cd5\u7684header\u7c7b\u578b");
            }
        }
        String fullContentType = contentType + ";charset=" + encoding;
        response.setContentType(fullContentType);
        if (noCache) {
            Servlets.setNoCacheHeader((HttpServletResponse)response);
        }
        return response;
    }

    public static Map<String, Object> toParameterMap(Object parameter) {
        if (parameter instanceof Map) {
            return (Map)parameter;
        }
        try {
            return PropertyUtils.describe((Object)parameter);
        }
        catch (Exception e) {
            ReflectionUtils.handleReflectionException((Exception)e);
            return null;
        }
    }

    public static Object fromJson(String json, JavaType typeOfT) {
        return normalMapper.fromJson(json, typeOfT);
    }

    public static <T> T fromJson(String json, Class<T> classOfT) {
        return (T)normalMapper.fromJson(json, classOfT);
    }
}

