/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.utils;

import com.google.common.collect.Maps;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.rocoinfo.rocomall.PropertyHolder;
import com.rocoinfo.rocomall.utils.RandomTools;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.StringUtils;

public class QRCodeUtils {
    private static final int DEFAULT_WIDTH = 200;
    private static final int DEFAULT_HEIGHT = 200;
    private static final String DEFAULT_FORMAT = "png";
    private static final Integer DEFAULT_MARGIN = 1;
    private static final ErrorCorrectionLevel DEFAULT_ECL = ErrorCorrectionLevel.L;
    private static final String DEFAULT_FILE_DIR = "qrcode";

    private QRCodeUtils() {
    }

    public static String generateQRCode(String content) {
        return QRCodeUtils.generateQRCode(content, 200, 200, DEFAULT_FORMAT, DEFAULT_MARGIN, DEFAULT_ECL, null);
    }

    public static String generateQRCode(String content, OutputStream os) {
        return QRCodeUtils.generateQRCode(content, 200, 200, DEFAULT_FORMAT, DEFAULT_MARGIN, DEFAULT_ECL, os);
    }

    public static String generateQRCode(String content, String format) {
        return QRCodeUtils.generateQRCode(content, 200, 200, format, DEFAULT_MARGIN, DEFAULT_ECL, null);
    }

    public static String generateQRCode(String content, int width, int height) {
        return QRCodeUtils.generateQRCode(content, width, height, DEFAULT_FORMAT, DEFAULT_MARGIN, DEFAULT_ECL, null);
    }

    public static String generateQRCode(String content, int width, int height, String format) {
        return QRCodeUtils.generateQRCode(content, width, height, format, DEFAULT_MARGIN, DEFAULT_ECL, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String generateQRCode(String content, int width, int height, String format, Integer margin, ErrorCorrectionLevel ecl, OutputStream os) {
        ConcurrentMap hint = Maps.newConcurrentMap();
        hint.put(EncodeHintType.CHARACTER_SET, "utf-8");
        hint.put(EncodeHintType.ERROR_CORRECTION, ecl);
        hint.put(EncodeHintType.MARGIN, margin);
        String extension = format;
        if (StringUtils.isBlank((CharSequence)extension)) {
            extension = DEFAULT_FORMAT;
        }
        try {
            String filePath = QRCodeUtils.getOrGenerateFilePath(extension);
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{filePath})) {
                BitMatrix matrix = new MultiFormatWriter().encode(content, BarcodeFormat.QR_CODE, width, height, (Map)hint);
                if (os == null) {
                    os = new FileOutputStream(new File(filePath));
                }
                MatrixToImageWriter.writeToStream((BitMatrix)matrix, (String)format, (OutputStream)os);
                String string = filePath;
                return string;
            }
        }
        catch (WriterException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    private static String getOrGenerateFilePath(String extension) {
        Calendar calendar = Calendar.getInstance();
        StringBuffer sb = new StringBuffer();
        String dir = sb.append(PropertyHolder.getUploadDir()).append("/qrcode").append("/" + calendar.get(1)).append("/" + (calendar.get(2) + 1)).append("/" + calendar.get(5)).toString();
        File imgDir = new File(dir);
        if (!imgDir.exists() && !imgDir.mkdirs()) {
            return null;
        }
        return dir + "/" + QRCodeUtils.generateFileName(extension);
    }

    private static String generateFileName(String extension) {
        return System.currentTimeMillis() + (long)RandomTools.rand(1000) + "." + extension;
    }
}

