/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.rocomall.utils;

import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import com.rocoinfo.rocomall.PropertyHolder;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SignValidationUtils {
    public static final String SIGN = "sign";
    public static final String SIGN_TYPE = "sign_type";

    private SignValidationUtils() {
    }

    private static Map<String, String> paramFilter(Map<String, String> paramPairs) {
        if (paramPairs == null) {
            return paramPairs;
        }
        return Maps.filterEntries(paramPairs, (Predicate)new Predicate<Map.Entry<String, String>>(){

            public boolean apply(Map.Entry<String, String> input) {
                String key = input.getKey();
                String value = input.getValue();
                if (StringUtils.isBlank((CharSequence)value)) {
                    return false;
                }
                return !SignValidationUtils.SIGN.equalsIgnoreCase(key) && !SignValidationUtils.SIGN_TYPE.equalsIgnoreCase(key);
            }
        });
    }

    public static String createLinkString(Map<String, String> paramPairs) {
        if (MapUtils.isEmpty(paramPairs)) {
            return "";
        }
        Map<String, String> sParaNew = SignValidationUtils.paramFilter(paramPairs);
        ArrayList<String> keys = new ArrayList<String>(sParaNew.keySet());
        Collections.sort(keys);
        String eq = "=";
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            String value = sParaNew.get(key);
            if (i == keys.size() - 1) {
                sb.append(key).append("=").append(value);
                continue;
            }
            sb.append(key).append("=").append(value).append("&");
        }
        return sb.toString();
    }

    public static String md5Sign(String linkString) {
        String needSignLink = linkString + PropertyHolder.getApiKey();
        try {
            return DigestUtils.md5Hex((byte[])needSignLink.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String md5Sign(Map<String, String> paramPairs) {
        return SignValidationUtils.md5Sign(SignValidationUtils.createLinkString(paramPairs));
    }

    public static boolean verifySign(Map<String, String> paramPairs, String signature) {
        String mySign = SignValidationUtils.md5Sign(paramPairs);
        return mySign.equals(signature);
    }

    public static boolean verifySign(String myMd5Sign, String signature) {
        return myMd5Sign.equals(signature);
    }

    public static boolean verifyBindSign(String platformCode, String ouid, String signature) {
        HashMap<String, String> bindParamMap = new HashMap<String, String>();
        bindParamMap.put("platformCode", platformCode);
        bindParamMap.put("ouid", ouid);
        return SignValidationUtils.verifySign(bindParamMap, signature);
    }
}

