package com.rocoinfo.user.center.api.request;

import com.rocoinfo.common.api.request.CommonRequest;
import com.rocoinfo.user.center.api.enums.IdentifyTypeEnum;
import org.hibernate.validator.constraints.NotBlank;

import javax.validation.constraints.NotNull;

/**
 * 注册请求.
 * Created by rocoinfo-zyj on 2017/4/10.
 */
public class RegisterRequest extends CommonRequest {

    /**
     * 注册类型
     */
    @NotNull(message = "注册类型不能为空")
    private IdentifyTypeEnum identifyTypeEnum;

    /**
     * 注册账号
     */
    @NotBlank(message = "注册账号不能为空")
    private String identify;

    /**
     * 注册密码
     */
    @NotBlank(message = "注册密码不能为空")
    private String password;

    /**
     * 来源
     */
    private String source;

    /**
     * 第三方账号
     */
    private String thirdIdentify;

    /**
     * 请求终端
     */
    private String requestTerminal;

    /**
     * 请求ip
     */
    private String requestIp;

    public String getSource() {
        return source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getThirdIdentify() {
        return thirdIdentify;
    }

    public void setThirdIdentify(String thirdIdentify) {
        this.thirdIdentify = thirdIdentify;
    }

    public String getRequestTerminal() {
        return requestTerminal;
    }

    public void setRequestTerminal(String requestTerminal) {
        this.requestTerminal = requestTerminal;
    }

    public String getRequestIp() {
        return requestIp;
    }

    public void setRequestIp(String requestIp) {
        this.requestIp = requestIp;
    }


    public String getIdentify() {
        return identify;
    }

    public void setIdentify(String identify) {
        this.identify = identify;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }


    public IdentifyTypeEnum getIdentifyTypeEnum() {
        return identifyTypeEnum;
    }

    public void setIdentifyTypeEnum(IdentifyTypeEnum identifyTypeEnum) {
        this.identifyTypeEnum = identifyTypeEnum;
    }

    @Override
    public String toString() {
        return "RegisterRequest{" +
                "requestIp='" + requestIp + '\'' +
                ", requestTerminal='" + requestTerminal + '\'' +
                ", thirdIdentify='" + thirdIdentify + '\'' +
                ", source='" + source + '\'' +
                ", password='" + password + '\'' +
                ", identify='" + identify + '\'' +
                ", identifyTypeEnum=" + identifyTypeEnum +
                '}';
    }
}
