package com.rocoinfo.user.center.api.request;

import com.rocoinfo.common.api.request.CommonRequest;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;

/**
 * Created with user-center.
 * User: zhanghs
 * Date: 2017/4/12
 * Time: 14:47
 * 凭证校验
 */
public class ValidateIdentifyRequest extends CommonRequest {
    @NotBlank(message = "凭证不能为空")
    @Length(max = 128)
    private String identify;

    @NotBlank(message = "密码不能为空")
    @Length(max=128)
    private String password;

    public String getIdentify() {
        return identify;
    }

    public void setIdentify(String identify) {
        this.identify = identify;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public String toString() {
        return "ValidateIdentifyRequest{" +
                "identify='" + identify + '\'' +
                ", password='" + password + '\'' +
                '}';
    }
}
