package com.rocoinfo.user.center.api.service;

import com.rocoinfo.common.api.response.CommonResponse;
import com.rocoinfo.user.center.api.request.*;
import com.rocoinfo.user.center.api.response.*;

/**
 * 用户服务.
 * Created by rocoinfo-zyj on 2017/4/10.
 */
public interface UserService {

    /** 注册 */
    CommonResponse<RegisterResponse> register(RegisterRequest request);

    /** 查询账号基本信息 */
    CommonResponse<QueryUserAccountInfoResponse> queryUserAccountInfo(QueryUserAccountInfoRequest request);

    /** 查询用户账号是否存在 */
    CommonResponse<QueryUserAccountExistResponse> queryUserAccountExist(QueryUserAccountExistRequest request);

    /**
     * 根据凭证、密码获取用户userId
     * @param request
     * @return userNo
     */
    CommonResponse<ValidateIdentifyResponse> validateIdentify(ValidateIdentifyRequest request);


    /**
     * 查询用户信息
     * @param request
     * @return
     */
    CommonResponse<QueryUserByUserNoResponse> queryUserByUserNo(QueryUserByUserNoRequest request);

    /**
     * 根据用户信息
     * @param request
     * @return
     */
    CommonResponse updateUserByUserNo(UpdateUserByUserNoRequest request);


}
