/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.wechat.facade;

import com.jfinal.kit.PropKit;
import com.jfinal.plugin.redis.RedisPlugin;
import com.jfinal.plugin.redis.RedisSentinelPlugin;
import com.jfinal.weixin.sdk.api.ApiConfig;
import com.jfinal.weixin.sdk.api.ApiConfigKit;
import com.jfinal.weixin.sdk.cache.IAccessTokenCache;
import com.jfinal.weixin.sdk.cache.RedisAccessTokenCache;
import java.util.HashSet;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.util.Pool;

public class WechatContext {
    public static String GLOBAL_CONFIG_FILENAME = "globalConfig.txt";
    public static String DEFAULT_CACHE_NAME = "roco_jfinal";

    public static String initWechatContext(Pool<Jedis> jedisPool) throws Exception {
        String initResult = "\u521d\u59cb\u5316jfinal-weixin\u73af\u5883\u6210\u529f";
        try {
            PropKit.use((String)GLOBAL_CONFIG_FILENAME);
        }
        catch (Exception fileExp) {
            return "\u8bfb\u53d6\u914d\u7f6e\u6587\u4ef6\u5931\u8d25";
        }
        ApiConfigKit.setDevMode((boolean)PropKit.getBoolean((String)"roco.jfinal.devMode", (Boolean)false));
        if (PropKit.getBoolean((String)"roco.jfinal.ifRedisCache", (Boolean)false).booleanValue()) {
            String cacheName = PropKit.get((String)"roco.jfinal.redis.CacheName", (String)DEFAULT_CACHE_NAME);
            if (jedisPool != null) {
                RedisPlugin redisPlugin = new RedisPlugin(cacheName);
                redisPlugin.start();
            } else if (PropKit.getBoolean((String)"roco.jfinal.ifSentinel", (Boolean)false).booleanValue()) {
                String masterName = PropKit.get((String)"roco.jfinal.redis.masterName", (String)"");
                String redisIp = PropKit.get((String)"roco.jfinal.redis.Host", (String)"");
                Integer redisPort = PropKit.getInt((String)"roco.jfinal.redis.Port", (Integer)0);
                String redisPassword = PropKit.get((String)"roco.jfinal.redis.password", (String)"");
                int redisDatabase = PropKit.getInt((String)"roco.jfinal.redis.database", (Integer)0);
                int redisTimeout = PropKit.getInt((String)"roco.jfinal.redis.timeout", (Integer)2000);
                HashSet<HostAndPort> sentinels = new HashSet<HostAndPort>();
                HostAndPort hostAndP = new HostAndPort(redisIp, redisPort.intValue());
                sentinels.add(hostAndP);
                GenericObjectPoolConfig poolConfig = new GenericObjectPoolConfig();
                RedisSentinelPlugin redisSentinelPlugin = new RedisSentinelPlugin(cacheName, masterName, sentinels, poolConfig, redisTimeout, redisPassword, redisDatabase);
                redisSentinelPlugin.start();
            } else {
                String redisHost = PropKit.get((String)"roco.jfinal.redis.Host", (String)"");
                int redisPort = PropKit.getInt((String)"roco.jfinal.redis.Port", (Integer)0);
                String redisPassword = PropKit.get((String)"roco.jfinal.redis.password", (String)"");
                int redisDatabase = PropKit.getInt((String)"roco.jfinal.redis.database", (Integer)0);
                int redisTimeout = PropKit.getInt((String)"roco.jfinal.redis.timeout", (Integer)2000);
                RedisPlugin redisPlugin = new RedisPlugin(cacheName, redisHost, redisPort, redisTimeout, redisPassword, redisDatabase);
                redisPlugin.start();
            }
            ApiConfigKit.setAccessTokenCache((IAccessTokenCache)new RedisAccessTokenCache(cacheName));
        }
        ApiConfig ac = new ApiConfig();
        ac.setToken(PropKit.get((String)"roco.jfinal.token"));
        ac.setAppId(PropKit.get((String)"roco.jfinal.appId"));
        ac.setAppSecret(PropKit.get((String)"roco.jfinal.appSecret"));
        ac.setEncryptMessage(PropKit.getBoolean((String)"roco.jfinal.encryptMessage", (Boolean)false).booleanValue());
        ac.setEncodingAesKey(PropKit.get((String)"roco.jfinal.encodingAesKey", (String)"setting it in config file"));
        ApiConfigKit.putApiConfig((ApiConfig)ac);
        ApiConfigKit.setThreadLocalAppId((String)ac.getAppId());
        return initResult;
    }
}

