/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.weixin.api;

import com.rocoinfo.weixin.model.ApiResult;
import com.rocoinfo.weixin.util.HttpUtils;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class JsApiTicketApi {
    private static final String JSAPI_TICKET = "https://api.weixin.qq.com/cgi-bin/ticket/getticket?access_token=ACCESS_TOKEN&type=jsapi";

    private JsApiTicketApi() {
    }

    public static ApiResult get(String accessToken) {
        String url = JSAPI_TICKET.replace("ACCESS_TOKEN", accessToken);
        return ApiResult.build(HttpUtils.get(url));
    }

    public static String getString(String accessToken) {
        String jsapiTicket = null;
        ApiResult res = JsApiTicketApi.get(accessToken);
        if (res.isSuccess()) {
            jsapiTicket = String.valueOf(res.get("ticket"));
        }
        return jsapiTicket;
    }

    public static Map<String, String> getSignature(String jsapi_ticket, String url) {
        HashMap<String, String> ret = new HashMap<String, String>();
        String nonce_str = JsApiTicketApi.create_nonce_str();
        String timestamp = JsApiTicketApi.create_timestamp();
        String signature = "";
        String string1 = "jsapi_ticket=" + jsapi_ticket + "&noncestr=" + nonce_str + "&timestamp=" + timestamp + "&url=" + url;
        System.out.println(string1);
        try {
            MessageDigest crypt = MessageDigest.getInstance("SHA-1");
            crypt.reset();
            crypt.update(string1.getBytes("UTF-8"));
            signature = JsApiTicketApi.byteToHex(crypt.digest());
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        ret.put("url", url);
        ret.put("jsapi_ticket", jsapi_ticket);
        ret.put("nonceStr", nonce_str);
        ret.put("timestamp", timestamp);
        ret.put("signature", signature);
        return ret;
    }

    private static String byteToHex(byte[] hash) {
        Formatter formatter = new Formatter();
        for (byte b : hash) {
            formatter.format("%02x", b);
        }
        String result = formatter.toString();
        formatter.close();
        return result;
    }

    private static String create_nonce_str() {
        return UUID.randomUUID().toString().substring(0, 15);
    }

    private static String create_timestamp() {
        return Long.toString(System.currentTimeMillis() / 1000L);
    }
}

