/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.weixin.ticket;

import com.rocoinfo.weixin.api.JsApiTicketApi;
import com.rocoinfo.weixin.ticket.DefaultTicketCache;
import com.rocoinfo.weixin.ticket.TicketCacheManager;
import com.rocoinfo.weixin.token.TokenManager;
import com.rocoinfo.weixin.util.StringUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DefaultTicketManager
implements TicketCacheManager<DefaultTicketCache> {
    private static final String CACHE_KEY = "ticket_cache_key";
    private final Map<String, DefaultTicketCache> ticketContainer = new ConcurrentHashMap<String, DefaultTicketCache>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DefaultTicketCache get() {
        new TokenManager();
        String accessToken = TokenManager.getAccessToken();
        DefaultTicketCache ticket = this.ticketContainer.get(CACHE_KEY);
        if (this.expire(ticket)) {
            Class<DefaultTicketManager> clazz = DefaultTicketManager.class;
            synchronized (DefaultTicketManager.class) {
                String ticketString;
                ticket = this.ticketContainer.get(CACHE_KEY);
                if (this.expire(ticket) && StringUtils.isNotBlank(ticketString = JsApiTicketApi.getString(accessToken))) {
                    ticket = new DefaultTicketCache(ticketString);
                    ticket.setCreateTime(System.currentTimeMillis());
                    this.ticketContainer.put(CACHE_KEY, ticket);
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return ticket;
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return ticket;
            }
        }
        return ticket;
    }

    private boolean expire(DefaultTicketCache ticket) {
        return ticket == null || ticket.getCreateTime() + ticket.getExpires() * 1000L <= System.currentTimeMillis();
    }

    @Override
    public void clear() {
        this.ticketContainer.clear();
    }
}

