package com.rocoinfo.weixin.config;

import com.rocoinfo.weixin.token.TokenCacheManager;

/**
 * <dl>
 * <dd>Description: 用于初始化的配置信息</dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2017/3/6 下午1:41</dd>
 * <dd>@author：Aaron</dd>
 * </dl>
 */
public class Configuration {

    /**
     * 参数配置
     */
    private ParamHolder paramHolder;

    /**
     * access token的缓存管理
     */
    private TokenCacheManager tokenCacheManager;

    public ParamHolder getParamHolder() {
        return paramHolder;
    }

    public TokenCacheManager getTokenCacheManager() {
        return tokenCacheManager;
    }

    /**
     * 注册自定义的参数配置
     *
     * @return
     */
    public <T extends ParamHolder> Configuration registerParamHolder(T t) {
        paramHolder = t;
        return this;
    }

    /**
     * 注入自定义的access
     *
     * @return
     */
    public <T extends TokenCacheManager> Configuration registerTokenCacheManager(T t) {
        tokenCacheManager = t;
        return this;
    }

}
