package com.rocoinfo.weixin.model;

import com.rocoinfo.weixin.util.JsonUtils;
import com.rocoinfo.weixin.util.StringUtils;

import java.util.HashMap;
import java.util.Map;

/**
 * <dl>
 * <dd>Description: 微信接口调用的返回结果</dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2017/3/6 上午11:03</dd>
 * <dd>@author：Aaron</dd>
 * </dl>
 */
public class ApiResult {

    /**
     * 微信返回结果（json串）
     */
    private String res;

    /**
     * 微信返回结果 json反序列化为key/value结构
     */
    private Map<String, Object> map;

    public static ApiResult build(String res) {
        return new ApiResult(res);
    }

    /**
     * json反序列化成map
     *
     * @return
     */
    private void deserialization() {
        if (map != null)
            return;
        if (StringUtils.isNotBlank(res)) {
            map = JsonUtils.fromJsonAsMap(this.res, String.class, Object.class);
        } else {
            map = new HashMap<>();
        }
    }

    public ApiResult(String res) {
        this.res = res;
    }

    /**
     * Json串原样返回
     *
     * @return
     */
    public String getRawJson() {
        return this.res;
    }

    /**
     * 将Json串转成Map<String,Object>返回。
     * 对外暴露的获取json转map结果的方法
     *
     * @return
     */
    public Map<String, Object> fromJsonAsMap() {
        this.deserialization();
        return map;
    }

    /**
     * 将返回结果反序列化为key/value结构，根据key获取value
     *
     * @param key key
     * @return value
     */
    public Object get(String key) {
        return fromJsonAsMap().get(key);
    }

    /**
     * 判断是否成功，通过微信返回的json串中是否包含errorcode
     *
     * @return
     */
    public boolean isSuccess() {
        this.deserialization();
        if (map.get("errcode") != null && !map.get("errcode").equals(0)) {
            return false;
        }
        return true;
    }

    /**
     * 获取微信返回的错误码
     *
     * @return
     */
    public Integer getErrorCode() {
        if (isSuccess()) {
            return 0;
        }
        return (Integer) map.get("errcode");
    }

    /**
     * 获取微信返回的错误信息
     *
     * @return
     */
    public String getErrorMsg() {
        this.deserialization();
        Object o = map.get("errmsg");
        if (o != null)
            return String.valueOf(o);
        return null;
    }

}
