package com.rocoinfo.weixin.msg.req.type;

/**
 * <dl>
 * <dd>Description: 微信事件类型</dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2017/3/15 下午4:46</dd>
 * <dd>@author：Aaron</dd>
 * </dl>
 */
public class EventType {

    private EventType() {
        super();
    }

    /**
     * 当用户的消息类型为事件时，即MsgType为event，则会传递一个Event参数，通过此参数判断事件类型。
     * 其中value为微信实际传过来的值
     * 事件分别是：关注事件、取消关注事件、扫描二维码事件、扫码未关注事件、上报地理位置事件、点击菜单事件（如果点击一级菜单弹出二级菜单，不会产生事件）
     * ps:当Event为SUBSCRIBE时，可能是由于用户扫描二维码，但并未关注公众号产生的事件。
     * 可以通过场景值（EventKey）来判断是关注事件还是由于扫码但未关注产生的事件。
     */
    public static final String SUBSCRIBE = "subscribe";
    public static final String UNSUBSCRIBE = "unsubscribe";
    public static final String SCAN = "SCAN";
    public static final String SCAN_UNSUBSCRIBE = "SCAN_UNSUBSCRIBE";
    public static final String LOCATION = "LOCATION";
    public static final String CLICK = "CLICK";
}
