package com.rocoinfo.weixin.msg.resp;

import com.rocoinfo.weixin.util.CDataAdapter;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.List;

/**
 * <dl>
 * <dd>Description: 回复图文消息</dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2017/3/17 下午2:20</dd>
 * <dd>@author：Aaron</dd>
 * </dl>
 */
@XmlRootElement(name = "xml")
public class ArticleResponse extends BaseResponse {

    public ArticleResponse() {
        super();
    }

    public ArticleResponse(String fromUser, String toUser, String createTime, String msgType, Article article) {
        super(fromUser, toUser, createTime, msgType);
        this.article = article;
    }

    /**
     * 图文消息列表
     */
    private Article article;

    public static class Article {

        public Article() {

        }

        public Article(List<Item> items) {
            this.items = items;
        }

        /**
         * 图文消息列表
         */
        private List<Item> items;

        @XmlElement(name = "item")
        public List<Item> getItems() {
            return items;
        }

        public void setItems(List<Item> items) {
            this.items = items;
        }
    }

    /**
     * 图文消息信息
     */
    public static class Item {

        public Item() {
            super();
        }

        public Item(String title, String description, String picUrl, String url) {
            this.title = title;
            this.description = description;
            this.picUrl = picUrl;
            this.url = url;
        }

        /**
         * 图文消息标题
         */
        private String title;

        /**
         * 图文消息描述
         */
        private String description;

        /**
         * 图片链接，支持JPG、PNG格式，较好的效果为大图360*200，小图200*200
         */
        private String picUrl;

        /**
         * 点击图文消息跳转链接
         */
        private String url;

        @XmlElement(name = "Title")
        @XmlJavaTypeAdapter(CDataAdapter.class)
        public String getTitle() {
            return title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        @XmlElement(name = "Description")
        @XmlJavaTypeAdapter(CDataAdapter.class)
        public String getDescription() {
            return description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        @XmlElement(name = "PicUrl")
        @XmlJavaTypeAdapter(CDataAdapter.class)
        public String getPicUrl() {
            return picUrl;
        }

        public void setPicUrl(String picUrl) {
            this.picUrl = picUrl;
        }

        @XmlElement(name = "Url")
        @XmlJavaTypeAdapter(CDataAdapter.class)
        public String getUrl() {
            return url;
        }

        public void setUrl(String url) {
            this.url = url;
        }
    }

    @XmlElement(name = "Articles")
    public Article getArticle() {
        return article;
    }

    public void setArticle(Article article) {
        this.article = article;
    }
}
