package com.rocoinfo.weixin.util;

import com.sun.xml.bind.marshaller.CharacterEscapeHandler;

import javax.xml.bind.*;
import javax.xml.transform.stream.StreamSource;
import java.io.*;

/**
 * <dl>
 * <dd>Description: xml工具类，提供xml和pojo之间的相互转换</dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2017/3/16 上午11:19</dd>
 * <dd>@author：Aaron</dd>
 * </dl>
 */
public class XmlUtils {

    private XmlUtils() {
        super();
    }

    /**
     * pojo转xml,默认编码及utf-8
     *
     * @param o pojo
     * @return
     */
    public static String toXml(Object o) {
        String result = null;
        StringWriter writer = null;
        try {
            JAXBContext context = JAXBContext.newInstance(o.getClass());
            Marshaller m = context.createMarshaller();
            // 设置输出是否格式化，不需要可以注释掉
            m.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, Boolean.TRUE);
            // 设置去掉生成的xml的头<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
            m.setProperty(Marshaller.JAXB_FRAGMENT, Boolean.TRUE);
            m.setProperty(Marshaller.JAXB_ENCODING, "UTF-8");
            // 当添加<![CDATA[xxx]]>时，小于号和大于号会被转译成&lt,&gt;将&lt,&gt转成 <>
            m.setProperty("com.sun.xml.bind.marshaller.CharacterEscapeHandler", new CharacterEscapeHandler() {

                @Override
                public void escape(char[] chars, int start, int len, boolean b, Writer writer) throws IOException {
                    writer.write(chars, start, len);
                }
            });
            writer = new StringWriter();
            m.marshal(o, writer);
            result = writer.toString();
        } catch (JAXBException e) {
            e.printStackTrace();
        } finally {
            IOUtils.closeQuietly(writer);
        }
        return result;
    }

    /**
     * xml转pojo
     *
     * @param xml   xml
     * @param clazz class
     * @param <T>   泛型
     * @return
     */
    public static <T> T fromXml(String xml, Class<T> clazz) {
        T t = null;
        try {
            JAXBContext context = JAXBContext.newInstance(clazz);
            Unmarshaller u = context.createUnmarshaller();
            JAXBElement<T> root = u.unmarshal(new StreamSource(new StringReader(xml)), clazz);
            t = root.getValue();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return t;
    }

    /**
     * 输入流读取xml转换成pojo
     *
     * @param is    输入流
     * @param clazz class
     * @param <T>   泛型
     * @return
     */
    public static <T> T fromXml(InputStream is, Class<T> clazz) {
        T t = null;
        try {
            JAXBContext context = JAXBContext.newInstance(clazz);
            Unmarshaller u = context.createUnmarshaller();
            JAXBElement<T> root = u.unmarshal(new StreamSource(), clazz);
            t = root.getValue();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return t;
    }

    /**
     * xml转map
     *
     * @param xml xml
     * @return
     */
//    public static Map<String, Object> xml2Map(String xml) {
//        Map<String, Object> map = new HashMap();
//        if (StringUtils.isNotBlank(xml)) {
//            // 使用SAX的方式解析DOM
//            SAXReader reader = new SAXReader();
//            Document document = null;
//            StringReader sr = null;
//            try {
//                sr = new StringReader(xml);
//                // 读取输入流
//                document = reader.read(sr);
//                // 获取根
//                document.getRootElement();
//                // 得到xml根元素
//                org.dom4j.Element root = document.getRootElement();
//                // 得到根元素的所有子节点
//                List<org.dom4j.Element> elementList = root.elements();
//
//                // 遍历所有子节点
//                for (org.dom4j.Element e : elementList)
//                    map.put(e.getName(), e.getText());
//            } catch (DocumentException e) {
//                e.printStackTrace();
//                return map;
//            } finally {
//                IOUtils.closeQuietly(sr);
//            }
//        }
//        return map;
//    }

    /**
     * xml转map，xml从输入流中读取
     *
     * @param is 输入流
     * @return
     */
//    public static Map<String, Object> xml2Map(InputStream is) {
//        Map<String, Object> map = new HashMap();
//        if (is != null) {
//            // 使用SAX的方式解析DOM
//            SAXReader reader = new SAXReader();
//            Document document = null;
//            try {
//                // 读取输入流
//                document = reader.read(is);
//                // 获取根
//                document.getRootElement();
//                // 得到xml根元素
//                org.dom4j.Element root = document.getRootElement();
//                // 得到根元素的所有子节点
//                List<org.dom4j.Element> elementList = root.elements();
//
//                // 遍历所有子节点
//                for (org.dom4j.Element e : elementList)
//                    map.put(e.getName(), e.getText());
//            } catch (DocumentException e) {
//                e.printStackTrace();
//                return map;
//            } finally {
//                // 释放资源
//                IOUtils.closeQuietly(is);
//            }
//        }
//        return map;
//    }
}
