package com.rocoinfo.weixin.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

/**
 * <dl>
 * <dd>Description: 默认通过Properties文件读取微信的配置参数</dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2017/3/3 下午3:06</dd>
 * <dd>@author：Aaron</dd>
 * </dl>
 */
public class DefaultParamHolder implements ParamHolder {

    private static Properties properties = new Properties();

    static {
        InputStream is = DefaultParamHolder.class.getResourceAsStream("/wechat.properties");
        try {
            properties.load(is);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getAppid() {
        return properties.getProperty("appid");
    }

    @Override
    public String getSecret() {
        return properties.getProperty("secret");
    }

    @Override
    public String getToken() {
        return properties.getProperty("token");
    }
}
