package com.rocoinfo.weixin.msg.handler;

import com.rocoinfo.weixin.msg.req.BaseRequest;
import com.rocoinfo.weixin.msg.resp.BaseResponse;

/**
 * <dl>
 * <dd>Description: 处理微信消息的Handler</dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2017/3/17 下午3:29</dd>
 * <dd>@author：Aaron</dd>
 * </dl>
 *
 * @param <R> 泛型，Request,必须是BaseRequest的子类 {@link BaseRequest}
 * @param <Q> 泛型，Response,必须是BaseResponse的子类 {@link BaseResponse}
 */
public interface MsgHandler<R extends BaseRequest, Q extends BaseResponse> {

    /**
     * Request的Class对象，主要为了方便将xml解析成javabean
     *
     * @return
     */
    Class<R> getRequestClass();

    /**
     * 判断是否可以处理，只有canhandle返回true，doHandle方法才会被调用
     * 消息类型的判断请参考:
     * {@link com.rocoinfo.weixin.msg.req.type.MsgType}
     * {@link com.rocoinfo.weixin.msg.req.type.EventType}
     *
     * @param r 微信消息的request
     * @return
     */
    boolean canHandle(R r);

    /**
     * 处理微信消息的handler
     *
     * @param r request
     * @return
     */
    Q doHandle(R r);
}
