/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.weixin.api;

import com.rocoinfo.weixin.config.ParamManager;
import com.rocoinfo.weixin.model.ApiResult;
import com.rocoinfo.weixin.util.HttpUtils;
import com.rocoinfo.weixin.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class OAuthApi {
    private static final String OAUTH_URL = "https://open.weixin.qq.com/connect/oauth2/authorize?appid=%s&redirect_uri=%s&response_type=code&scope=%s&state=%s#wechat_redirect";
    private static final String GET_ACCESS_TOKEN_URL = "https://api.weixin.qq.com/sns/oauth2/access_token?appid=%s&secret=%s&code=%s&grant_type=authorization_code";
    private static final String REFRESH_ACCESS_TOKEN_URL = "https://api.weixin.qq.com/sns/oauth2/refresh_token?appid=%s&grant_type=refresh_token&refresh_token=%s";
    private static final String GET_USER_INFO_URL = "https://api.weixin.qq.com/sns/userinfo?access_token=%s&openid=%s&lang=%s";
    private static final String DEFAULT_LANG = "zh_CN";
    private static final String DEFAULT_ENCODE_CHARACTER = "UTF-8";

    private OAuthApi() {
    }

    public static String buildUrl(String url, String state, Type type) {
        if (StringUtils.isBlank(url) || type == null) {
            throw new IllegalArgumentException("url\u6216type\u4e3a\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return String.format(OAUTH_URL, ParamManager.getAppid(), OAuthApi.URLEncode(url), type.getValue(), state);
    }

    public static ApiResult getAccessToken(String code) {
        if (StringUtils.isBlank(code)) {
            throw new NullPointerException("code is null");
        }
        String url = String.format(GET_ACCESS_TOKEN_URL, ParamManager.getAppid(), ParamManager.getSecret(), code);
        return ApiResult.build(HttpUtils.get(url));
    }

    public static String getOpenid(String code) {
        ApiResult res = OAuthApi.getAccessToken(code);
        if (res.isSuccess()) {
            return (String)res.fromJsonAsMap().get("openid");
        }
        return null;
    }

    public static ApiResult refreshAccessToken(String refreshToken) {
        if (StringUtils.isBlank(refreshToken)) {
            throw new NullPointerException("refresh token is null");
        }
        String url = String.format(REFRESH_ACCESS_TOKEN_URL, ParamManager.getAppid(), refreshToken);
        return ApiResult.build(HttpUtils.get(url));
    }

    public static ApiResult getUserInfo(String accessTokne, String openid, String lang) {
        if (StringUtils.isAnyBlank(accessTokne, openid)) {
            throw new NullPointerException("access token or openid is null");
        }
        if (StringUtils.isBlank(lang)) {
            lang = DEFAULT_LANG;
        }
        String url = String.format(GET_USER_INFO_URL, accessTokne, lang);
        return ApiResult.build(HttpUtils.get(url));
    }

    private static String URLEncode(String s) {
        String res = null;
        try {
            res = URLEncoder.encode(s, DEFAULT_ENCODE_CHARACTER);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("url encoding failed!");
        }
        return res;
    }

    public static enum Type {
        BASE("snsapi_base"),
        INFO("snsapi_userinfo");

        private String value;

        private Type(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

