/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.weixin.util;

import com.rocoinfo.weixin.config.ParamManager;
import com.rocoinfo.weixin.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;

public class SignUtils {
    private SignUtils() {
    }

    public static String encryptMessageBySHA1(String message) throws UnsupportedEncodingException, NoSuchAlgorithmException {
        if (StringUtils.isBlank(message)) {
            return "";
        }
        MessageDigest crypt = MessageDigest.getInstance("SHA-1");
        crypt.reset();
        crypt.update(message.getBytes("UTF-8"));
        return SignUtils.byteToStr(crypt.digest());
    }

    public static boolean checkSignature(String signature, String timestamp, String nonce) {
        Object[] paramArr = new String[]{ParamManager.getToken(), timestamp, nonce};
        Arrays.sort(paramArr);
        String content = ((String)paramArr[0]).concat((String)paramArr[1]).concat((String)paramArr[2]);
        String ciphertext = null;
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            byte[] digest = md.digest(content.toString().getBytes());
            ciphertext = SignUtils.byteToStr(digest);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return ciphertext != null ? ciphertext.equals(signature.toUpperCase()) : false;
    }

    private static String byteToStr(byte[] byteArray) {
        String strDigest = "";
        for (int i = 0; i < byteArray.length; ++i) {
            strDigest = strDigest + SignUtils.byteToHexStr(byteArray[i]);
        }
        return strDigest;
    }

    private static String byteToHexStr(byte mByte) {
        char[] Digit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        char[] tempArr = new char[]{Digit[mByte >>> 4 & 0xF], Digit[mByte & 0xF]};
        String s = new String(tempArr);
        return s;
    }
}

