package com.rocoinfo.weixin.api;

import com.rocoinfo.weixin.model.payment.req.UnifiedOrderReq;
import com.rocoinfo.weixin.model.payment.resp.UnifiedOrderResp;
import com.rocoinfo.weixin.util.HttpUtils;
import com.rocoinfo.weixin.util.PaymentUtils;
import com.rocoinfo.weixin.util.StringUtils;
import com.rocoinfo.weixin.util.XmlUtils;

/**
 * <dl>
 * <dd>Description: 微信支付工具类</dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2017/9/18 上午11:54</dd>
 * <dd>@author：Aaron</dd>
 * </dl>
 */
public class PaymentApi extends BaseApi {

    private PaymentApi() {

    }

    /**
     * 生成指定位数的随机串
     *
     * @param len 随机串位数
     * @return 随机串
     */
    public static String generateNonceStr(int len) {
        return PaymentUtils.generateNonceStr(len);
    }

    /**
     * 根据微信支付统一下单接口的请求数据，生成相应的签名
     *
     * @param req 请求数据
     * @return
     */
    public static String calculateSign(UnifiedOrderReq req, String key) {
        return PaymentUtils.calculateSign(req, key);
    }

    /**
     * 统一下单的url
     */
    private static final String UNIFIED_ORDER_URL = "https://api.mch.weixin.qq.com/pay/unifiedorder";

    /**
     * 微信统一下单接口
     *
     * @param req 统一下单接口请求参数
     * @return
     */
    public static UnifiedOrderResp unifiedOrder(UnifiedOrderReq req) {
        if (req == null) {
            throw new RuntimeException("统一下单请求对象为空！");
        }
        String res = HttpUtils.post(UNIFIED_ORDER_URL, XmlUtils.toXml(req));
        return XmlUtils.fromXml(res, UnifiedOrderResp.class);
    }
}
