package com.rocoinfo.weixin.api;

import com.rocoinfo.weixin.model.ApiResult;
import com.rocoinfo.weixin.util.*;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <dl>
 * <dd>Description: 会员管理接口</dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2017/3/6 上午11:00</dd>
 * <dd>@author：Aaron</dd>
 * </dl>
 */
public class UserApi extends BaseApi {

    /**
     * 获取用户信息接口
     */
    private static final String GET_USER_INFO_URL = "https://api.weixin.qq.com/cgi-bin/user/info?access_token=";

    private UserApi() {
        super();
    }

    /**
     * 获取用户信息
     *
     * @param openid 用户openid
     * @return 返回用户信息
     */
    public static ApiResult info(String openid) {
        StringBuilder url = new StringBuilder(GET_USER_INFO_URL)
                .append(getAccessToken())
                .append("&openid=")
                .append(openid)
                .append("&lang=zh_CN");
        return ApiResult.build(HttpUtils.get(url.toString()));
    }

    /**
     * 批量获取用户信息的url
     */
    private static final String BATCH_GET_URL = "https://api.weixin.qq.com/cgi-bin/user/info/batchget?access_token=";

    /**
     * 批量获取用户信息
     *
     * @param openids 用户openid集合
     * @return 返回用户信息集合的Json
     */
    public static ApiResult batchGet(List<String> openids) {
        Map<String, List<Map<String, String>>> params = new HashMap<>();

        List<Map<String, String>> users = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(openids)) {
            for (String openid : openids) {
                users.add(MapUtils.of("openid", openid, "lang", "zh-CN"));
            }
        }
        params.put("user_list", users);

        String url = BATCH_GET_URL + getAccessToken();
        return ApiResult.build(HttpUtils.post(url, JsonUtils.toJson(params)));
    }

    /**
     * 设置用户备注接口
     */
    private static final String SET_USER_REMARK_URL = "https://api.weixin.qq.com/cgi-bin/user/info/updateremark?access_token=";

    /**
     * 设置用户备注
     *
     * @param openid 用户openid
     * @param remark 备注内容
     * @return 设置备注结果
     */
    public static ApiResult setUserRemark(String openid, String remark) {
        Map<String, String> params = MapUtils.of("openid", openid, "remark", remark);
        String url = SET_USER_REMARK_URL + getAccessToken();
        return ApiResult.build(HttpUtils.post(url, JsonUtils.toJson(params)));
    }

    /**
     * 获取用户openid列表接口url
     */
    private static final String GET_USER_LIST_URL = "https://api.weixin.qq.com/cgi-bin/user/get?access_token=";

    /**
     * 获取用户openid列表接口
     *
     * @param openid 第一个拉取的openid，不填默认从头开始拉取
     * @return 返回用户openid列表
     */
    public static ApiResult getUseropenids(String openid) {
        StringBuilder url = new StringBuilder(GET_USER_LIST_URL).append(getAccessToken());
        if (StringUtils.isNotBlank(openid)) {
            url.append("&next_openid=").append(openid);
        }
        return ApiResult.build(HttpUtils.get(url.toString()));
    }
}
