package com.rocoinfo.weixin.msg;

import com.rocoinfo.weixin.msg.handler.MsgHandler;
import com.rocoinfo.weixin.msg.req.BaseRequest;
import com.rocoinfo.weixin.msg.resp.BaseResponse;
import com.rocoinfo.weixin.util.XmlUtils;

import java.io.InputStream;

/**
 * <dl>
 * <dd>Description: 消息处理的调用类</dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2017/3/19 下午2:56</dd>
 * <dd>@author：Aaron</dd>
 * </dl>
 */
public class HandlerInvoker<R extends BaseRequest, Q extends BaseResponse> {

    private MsgHandler<R, Q> handler;

    public HandlerInvoker(MsgHandler<R, Q> handler) {
        this.handler = handler;
    }

    public Q invoke(InputStream is) {
        // 微信端请求
        R req = XmlUtils.fromXml(is, handler.getRequestClass());
        if (req != null && handler.canHandle(req)) {
            try {
                return handler.doHandle(req);
            } catch (Exception e) {
                return null;
            }
        }
        return null;
    }
}
