package com.rocoinfo.weixin.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

/**
 * <dl>
 * <dd>Description: </dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2017/9/18 下午2:25</dd>
 * <dd>@author：Aaron</dd>
 * </dl>
 */
public class MD5Utils {

    private static final char[] HEX_DIGITS = "0123456789abcdef".toCharArray();

    /**
     * md5签名
     *
     * @param s
     * @return
     */
    public static String md5(String s) {
        if (s == null) {
            return StringUtils.BLANK;
        }
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("MD5");
            byte[] bytes = md.digest(s.getBytes("utf-8"));
            return toHex(bytes).toUpperCase();
        } catch (Exception e) {
            throw new RuntimeException();
        }
    }

    public static String toHex(byte[] bytes) {
        StringBuilder ret = new StringBuilder(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            ret.append(HEX_DIGITS[bytes[i] >> 4 & 15]);
            ret.append(HEX_DIGITS[bytes[i] & 15]);
        }
        return ret.toString();
    }
}
